/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.mixin;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.SimplySwords;
import net.sweenus.simplyswords.compat.eldritch_end.EldritchEndCompatMethods;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"isDeadOrDying()Z"}, cancellable=true)
    public void simplyswords$tick(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (!livingEntity.level().isClientSide() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Level world = player.level();
            ItemStack stack = player.getMainHandItem();
            if (player.getHealth() <= 0.0f && !player.getCooldowns().isOnCooldown(stack.getItem()) && (stack.is((Item)ItemsRegistry.WAXWEAVER.get()) || stack.is((Item)ItemsRegistry.WICKPIERCER.get()))) {
                int skillCooldown = Config.uniqueEffects.waxweaver.cooldown;
                player.setHealth(player.getMaxHealth());
                HelperMethods.incrementStatusEffect((LivingEntity)player, (Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, 100, 2, 3);
                player.getCooldowns().addCooldown(stack.getItem(), skillCooldown);
                world.playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), player.getSoundSource(), 0.7f, 1.0f);
                world.playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.SPELL_MISC_02.get(), player.getSoundSource(), 0.8f, 1.0f);
                cir.setReturnValue((Object)false);
            }
        }
    }

    @ModifyVariable(method={"getDamageAfterMagicAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float simplyswords$modifyDamageAmount(float amount, DamageSource source) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (!livingEntity.level().isClientSide()) {
            MobEffectInstance voidcloakEffect = livingEntity.getEffect(EffectRegistry.getReference(EffectRegistry.VOIDCLOAK));
            MobEffectInstance ribbonwrathEffect = livingEntity.getEffect(EffectRegistry.getReference(EffectRegistry.RIBBONWRATH));
            MobEffectInstance soulTetherEffect = livingEntity.getEffect(EffectRegistry.getReference(EffectRegistry.SOULTETHER));
            if (voidcloakEffect != null) {
                int amplifier = voidcloakEffect.getAmplifier();
                float reductionFactor = 1.0f - (float)(amplifier + 1) * 0.1f;
                amount *= reductionFactor;
                HelperMethods.decrementStatusEffect(livingEntity, EffectRegistry.getReference(EffectRegistry.VOIDCLOAK));
            }
            if (ribbonwrathEffect != null) {
                float reductionFactor = 0.85f;
                amount *= reductionFactor;
            }
            if (soulTetherEffect != null) {
                float reductionFactor = 0.5f;
                amount *= reductionFactor;
            }
        }
        return amount;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    public void simplyswords$tick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (!livingEntity.level().isClientSide() && SimplySwords.passVersionCheck("eldritch_end", SimplySwords.minimumEldritchEndVersion) && BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)"simplyswords:voidhunger")) != null) {
            EldritchEndCompatMethods.generateVoidcloakStacks(livingEntity);
        }
    }
}

