/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class WatcherSwordItem
extends UniqueSwordItem {
    public WatcherSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            ServerLevel world = (ServerLevel)attacker.level();
            int watcherChance = Config.uniqueEffects.watcher.watcherChance;
            int omenChance = Config.uniqueEffects.watcher.omenChance;
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.getRandom().nextInt(100) <= watcherChance) {
                double hradius = Config.uniqueEffects.watcher.watcherRadius;
                double vradius = Config.uniqueEffects.watcher.watcherRadius / 2.0;
                double x = target.getX();
                double y = target.getY();
                double z = target.getZ();
                float rAmount = Config.uniqueEffects.watcher.watcherRestoreAmount;
                AABB box = new AABB(x + hradius, y + vradius, z + hradius, x - hradius, y - vradius, z - hradius);
                for (Entity entity : world.getEntities((Entity)attacker, box, EntitySelector.ENTITY_STILL_ALIVE)) {
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire((LivingEntity)entity, attacker)) continue;
                    entity.hurt(attacker.damageSources().indirectMagic((Entity)attacker, (Entity)attacker), rAmount);
                    attacker.heal(rAmount);
                    BlockPos position2 = entity.blockPosition();
                    world.playSound(null, position2, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_02.get(), entity.getSoundSource(), 0.05f, 1.2f);
                }
            }
            if (attacker.getRandom().nextInt(100) <= omenChance) {
                BlockPos position = target.blockPosition();
                float overallAbsorptionCap = Config.uniqueEffects.abilityAbsorptionCap;
                float absorptionCap = Config.uniqueEffects.watcher.omenAbsorptionCap;
                float threshold = Config.uniqueEffects.watcher.omenInstantKillThreshold * target.getMaxHealth();
                float remainingHealth = target.getHealth();
                if (remainingHealth <= threshold) {
                    attacker.setAbsorptionAmount(Math.min(Math.min(absorptionCap, overallAbsorptionCap), attacker.getAbsorptionAmount() + remainingHealth));
                    world.playSound(null, position, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), target.getSoundSource(), 0.7f, 1.2f);
                    target.hurt(attacker.damageSources().indirectMagic((Entity)attacker, (Entity)attacker), 1000.0f);
                }
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.ENCHANT, (ParticleOptions)ParticleTypes.ENCHANT, (ParticleOptions)ParticleTypes.MYCELIUM, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.watchersworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.watchersworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.watchersworditem.tooltip3", (Object[])new Object[]{Float.valueOf(Config.uniqueEffects.watcher.omenInstantKillThreshold * 100.0f)}).setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.watchersworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.watchersworditem.tooltip5").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.watchersworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.watchersworditem.tooltip7").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    @Override
    protected ResourceLocation getConfigPath() {
        return ResourceLocation.parse((String)"simplyswords.unique_effects.watcher");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int watcherChance;
        @ValidatedDouble.Restrict(min=1.0)
        public double watcherRadius;
        @ValidatedFloat.Restrict(min=0.0f)
        public float watcherRestoreAmount;
        @ValidatedFloat.Restrict(min=0.0f, max=100.0f)
        public float omenAbsorptionCap;
        @ValidatedInt.Restrict(min=0, max=100)
        public int omenChance;
        @ValidatedFloat.Restrict(min=0.0f, max=1.0f)
        public float omenInstantKillThreshold;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ItemsRegistry.WATCHER_CLAYMORE.get();
            supplierArray[1] = () -> ItemsRegistry.WATCHING_WARGLAIVE.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.watcherChance = 5;
            this.watcherRadius = 8.0;
            this.watcherRestoreAmount = 0.5f;
            this.omenAbsorptionCap = 20.0f;
            this.omenChance = 5;
            this.omenInstantKillThreshold = 0.25f;
        }
    }
}

