/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class SoulkeeperSwordItem
extends UniqueSwordItem
implements TwoHandedWeapon {
    public SoulkeeperSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            int hitChance = Config.uniqueEffects.soulkeeper.chance;
            int duration = Config.uniqueEffects.soulkeeper.duration;
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.getRandom().nextInt(100) <= hitChance) {
                if (attacker.hasEffect(MobEffects.DIG_SLOWDOWN) && attacker.hasEffect(MobEffects.DAMAGE_RESISTANCE)) {
                    int a = attacker.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier() + 1;
                    if (attacker.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier() <= 2) {
                        attacker.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, duration, a), (Entity)attacker);
                        attacker.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, duration, a), (Entity)attacker);
                    }
                } else {
                    attacker.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, duration, 1), (Entity)attacker);
                    attacker.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, duration, 1), (Entity)attacker);
                }
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!user.level().isClientSide()) {
            double hradius = Config.uniqueEffects.soulkeeper.radius;
            double vradius = Config.uniqueEffects.soulkeeper.radius;
            double x = user.getX();
            double y = user.getY();
            double z = user.getZ();
            ServerLevel serverWorld = (ServerLevel)user.level();
            AABB box = new AABB(x + hradius, y + vradius, z + hradius, x - hradius, y - vradius, z - hradius);
            for (Entity entity : serverWorld.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entity;
                if (!user.hasEffect(MobEffects.DIG_SLOWDOWN) || !HelperMethods.checkFriendlyFire((LivingEntity)entity, (LivingEntity)user)) continue;
                le.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, user.getEffect(MobEffects.DIG_SLOWDOWN).getDuration(), user.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()), (Entity)user);
                world.playSound(null, entity, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), entity.getSoundSource(), 0.1f, 1.0f);
            }
            if (user.hasEffect(MobEffects.DIG_SLOWDOWN) && user.hasEffect(MobEffects.DAMAGE_RESISTANCE)) {
                user.addEffect(new MobEffectInstance(MobEffects.REGENERATION, user.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier() * 40, 2), (Entity)user);
                user.removeEffect(MobEffects.DIG_SLOWDOWN);
                user.removeEffect(MobEffects.DAMAGE_RESISTANCE);
            }
        }
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.SOUL, (ParticleOptions)ParticleTypes.SOUL, (ParticleOptions)ParticleTypes.SPORE_BLOSSOM_AIR, false);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.soulsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.soulsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.soulsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.soulsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.soulsworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.soulsworditem.tooltip6").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedDouble.Restrict(min=1.0)
        public double radius;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.SOULKEEPER.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 75;
            this.duration = 250;
            this.radius = 5.0;
        }
    }
}

