/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.entity.FrostfallEntity;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class FrostfallSwordItem
extends UniqueSwordItem {
    public FrostfallSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.level().isClientSide()) {
            super.hurtEnemy(stack, target, attacker);
        }
        HelperMethods.playHitSounds(attacker, target);
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (user.level().isClientSide()) {
            return super.use(world, user, hand);
        }
        float abilityDamage = HelperMethods.spellScaledDamage("frost", (Entity)user, Config.uniqueEffects.frostfall.spellScaling, Config.uniqueEffects.frostfall.damage);
        float pulseDamage = HelperMethods.spellScaledDamage("frost", (Entity)user, Config.uniqueEffects.frostfall.spellScaling, Config.uniqueEffects.frostfall.pulseDamage);
        ItemStack itemStack = user.getItemInHand(hand);
        if (!world.isClientSide) {
            itemStack = user.getItemInHand(hand);
            FrostfallEntity frostfallEntity = new FrostfallEntity(world, (LivingEntity)user, itemStack.copy());
            frostfallEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
            frostfallEntity.setYRot(user.getYRot());
            frostfallEntity.setXRot(user.getXRot());
            frostfallEntity.primaryBaseDamage = abilityDamage;
            frostfallEntity.detonateDamage = pulseDamage;
            frostfallEntity.addedChance = Config.uniqueEffects.frostfall.chance;
            frostfallEntity.detonateRadius = Config.uniqueEffects.frostfall.radius;
            frostfallEntity.duration = Config.uniqueEffects.frostfall.duration;
            if (hand == InteractionHand.OFF_HAND) {
                frostfallEntity.offhandThrow = true;
            }
            frostfallEntity.setPosRaw(user.getX(), user.getEyeY() - 0.5, user.getZ());
            world.addFreshEntity((Entity)frostfallEntity);
            if (!user.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
        }
        user.swing(hand);
        user.getCooldowns().addCooldown((Item)this, Config.uniqueEffects.frostfall.cooldown);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.SNOWFLAKE, (ParticleOptions)ParticleTypes.SNOWFLAKE, (ParticleOptions)ParticleTypes.WHITE_ASH, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.frostfallsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.frostfallsworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.frostfallsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.frostfallsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.frostfallsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.frostfallsworditem.tooltip5").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "frost");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=1, max=100)
        public int chance;
        @ValidatedInt.Restrict(min=1)
        public int cooldown;
        @ValidatedFloat.Restrict(min=1.0f)
        public float damage;
        @ValidatedFloat.Restrict(min=0.0f)
        public float pulseDamage;
        @ValidatedInt.Restrict(min=1)
        public int duration;
        @ValidatedDouble.Restrict(min=6.0)
        public double radius;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.FROSTFALL.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 25;
            this.cooldown = 3;
            this.damage = 11.0f;
            this.pulseDamage = 11.0f;
            this.duration = 80;
            this.radius = 8.0;
            this.spellScaling = 1.4f;
        }
    }
}

