/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import dev.architectury.platform.Platform;
import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class EnigmaSwordItem
extends UniqueSwordItem {
    public EnigmaSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!user.level().isClientSide()) {
            BlockState state;
            ServerLevel serverWorld = (ServerLevel)user.level();
            BlockState currentState = world.getBlockState(user.blockPosition().above(4).relative(user.getMotionDirection(), 3));
            if (currentState == (state = Blocks.AIR.defaultBlockState())) {
                world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.DARK_SWORD_ATTACK_WITH_BLOOD_02.get(), user.getSoundSource(), 0.4f, 0.8f);
                BattleStandardDarkEntity banner = (BattleStandardDarkEntity)((EntityType)EntityRegistry.BATTLESTANDARDDARK.get()).spawn(serverWorld, user.blockPosition().above(1).relative(user.getMotionDirection(), 2), MobSpawnType.MOB_SUMMONED);
                if (banner != null) {
                    banner.setDeltaMovement(0.0, -1.0, 0.0);
                    banner.ownerEntity = user;
                    banner.decayRate = Config.uniqueEffects.enigma.enigmaDecayRate;
                    banner.standardType = "enigma";
                    banner.setCustomName((Component)Component.translatable((String)"entity.simplyswords.battlestandard.name", (Object[])new Object[]{user.getName()}));
                    banner.setCustomNameVisible(false);
                    banner.setInvisible(true);
                    banner.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.ELEMENTAL_VORTEX), 900, 11, false, false, false));
                }
                user.getCooldowns().addCooldown((Item)this, Config.uniqueEffects.enigma.enigmaCooldown);
            }
        }
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        if (entity.onGround() && Platform.isModLoaded((String)"bettercombat") && HelperMethods.isWalking(entity) && entity instanceof Player && (player = (Player)entity).getMainHandItem().is((Item)ItemsRegistry.ENIGMA.get())) {
            BlockState blockState = entity.getBlockStateOn();
            BlockParticleOption particleEffect = new BlockParticleOption(ParticleTypes.BLOCK, blockState);
            double bodyRadians = Math.toRadians(entity.getVisualRotationYInDegrees() + 180.0f);
            Vec3 backwardDirection = new Vec3(-Math.sin(bodyRadians), 0.0, Math.cos(bodyRadians)).scale(1.1);
            double strafeRadians = Math.toRadians(entity.getVisualRotationYInDegrees() + 90.0f);
            Vec3 strafeDirection = new Vec3(-Math.sin(strafeRadians), 0.0, Math.cos(strafeRadians));
            Vec3 movementVector = entity.getDeltaMovement();
            double strafeMagnitude = movementVector.dot(strafeDirection.normalize());
            double pivotOffsetFactor = 3.0;
            Vec3 pivotOffset = strafeDirection.scale(strafeMagnitude * pivotOffsetFactor);
            Vec3 adjustedBackwardDirection = backwardDirection.subtract(pivotOffset);
            Vec3 handPosOffset = entity.getHandHoldingItemAngle(stack.getItem());
            double particleX = entity.getX() + adjustedBackwardDirection.x + handPosOffset.x();
            double particleY = entity.getY() + handPosOffset.y();
            double particleZ = entity.getZ() + adjustedBackwardDirection.z + handPosOffset.z();
            particleY = entity.onGround() ? entity.getY() : particleY;
            world.addParticle((ParticleOptions)particleEffect, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
            world.addParticle((ParticleOptions)ParticleTypes.POOF, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.enigmasworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.enigmasworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.enigmasworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.enigmasworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.enigmasworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.enigmasworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.enigmasworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.enigmasworditem.tooltip8").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int enigmaCooldown;
        @ValidatedDouble.Restrict(min=1.0)
        public double enigmaChaseRadius;
        @ValidatedInt.Restrict(min=1)
        public int enigmaDecayRate;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.ENIGMA.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.enigmaCooldown = 800;
            this.enigmaChaseRadius = 16.0;
            this.enigmaDecayRate = 2;
        }
    }
}

