/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public record TargetedLocationComponent(UUID uuid, double lastX, double lastY, double lastZ) {
    private static final UUID DEFAULT_UUID = UUID.randomUUID();
    public static TargetedLocationComponent DEFAULT = new TargetedLocationComponent(DEFAULT_UUID, 0.0, 0.0, 0.0);
    public static Codec<TargetedLocationComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.AUTHLIB_CODEC.fieldOf("uuid").forGetter(TargetedLocationComponent::uuid), (App)Codec.DOUBLE.fieldOf("x").forGetter(TargetedLocationComponent::lastX), (App)Codec.DOUBLE.fieldOf("y").forGetter(TargetedLocationComponent::lastY), (App)Codec.DOUBLE.fieldOf("z").forGetter(TargetedLocationComponent::lastZ)).apply((Applicative)instance, TargetedLocationComponent::new));
    public static StreamCodec<RegistryFriendlyByteBuf, TargetedLocationComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.map(UUID::fromString, UUID::toString), TargetedLocationComponent::uuid, (StreamCodec)ByteBufCodecs.DOUBLE, TargetedLocationComponent::lastX, (StreamCodec)ByteBufCodecs.DOUBLE, TargetedLocationComponent::lastY, (StreamCodec)ByteBufCodecs.DOUBLE, TargetedLocationComponent::lastZ, TargetedLocationComponent::new);

    public TargetedLocationComponent(double lastX, double lastY, double lastZ) {
        this(UUID.randomUUID(), lastX, lastY, lastZ);
    }

    @Nullable
    public LivingEntity getEntity(ServerLevel world) {
        if (this.uuid == DEFAULT_UUID) {
            return null;
        }
        Entity entity = world.getEntity(this.uuid);
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    public TargetedLocationComponent setTarget(Entity newTarget) {
        return new TargetedLocationComponent(newTarget.getUUID(), this.lastX, this.lastY, this.lastZ);
    }
}

