/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SimplySwordsBeeEntity
extends Bee
implements OwnableEntity {
    public UUID ownerUuid;
    public static int lifespan = 200;

    public SimplySwordsBeeEntity(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createSimplyBeeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 35.0).add(Attributes.FLYING_SPEED, (double)1.6f).add(Attributes.MOVEMENT_SPEED, (double)0.6f).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public void tick() {
        this.setInvulnerable(true);
        if (this.hasStung() || this.tickCount > lifespan) {
            this.discard();
        }
        super.tick();
    }

    public boolean doHurtTarget(Entity target) {
        target.invulnerableTime = 0;
        return super.doHurtTarget(target);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUuid;
    }

    public void setOwner(LivingEntity livingEntity) {
        this.ownerUuid = livingEntity.getUUID();
    }
}

