/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import com.google.common.base.Suppliers;
import java.util.Comparator;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class BattleStandardDarkEntity
extends PathfinderMob {
    public static final Supplier<EntityType<BattleStandardDarkEntity>> TYPE = Suppliers.memoize(() -> EntityType.Builder.of(BattleStandardDarkEntity::new, (MobCategory)MobCategory.MISC).build("battlestandarddark"));
    public Player ownerEntity;
    public String standardType;
    public int decayRate;

    public static AttributeSupplier.Builder createBattleStandardDarkAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 100.0).add(Attributes.STEP_HEIGHT, 3.0);
    }

    public BattleStandardDarkEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.setInvisible(true);
    }

    protected boolean isImmobile() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return this.ownerEntity == null;
    }

    public void baseTick() {
        if (!this.level().isClientSide()) {
            if (this.tickCount % 10 == 0) {
                this.setHealth(this.getHealth() - (float)this.decayRate);
                if (this.ownerEntity == null) {
                    this.setHealth(this.getHealth() - 1000.0f);
                }
                HelperMethods.spawnOrbitParticles((ServerLevel)this.level(), this.position(), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, 0.5, 6);
                if (this.ownerEntity != null && this.distanceTo((Entity)this.ownerEntity) < 3.0f) {
                    HelperMethods.incrementStatusEffect((LivingEntity)this.ownerEntity, (Holder<MobEffect>)MobEffects.DIG_SPEED, 60, 1, 7);
                }
            }
            if (this.ownerEntity != null && this.standardType != null) {
                AABB box;
                float abilityDamage;
                LivingEntity le;
                if (!this.ownerEntity.isAlive()) {
                    this.setHealth(this.getHealth() - 1000.0f);
                }
                int radius = 6;
                if (this.standardType.equals("enigma") && !this.isInvisible()) {
                    this.setInvisible(true);
                }
                if (this.standardType.equals("enigma")) {
                    radius = 2;
                    double moveRadius = Config.uniqueEffects.enigma.enigmaChaseRadius;
                    AABB box2 = HelperMethods.createBox((Entity)this, moveRadius);
                    Entity closestEntity = this.level().getEntities((Entity)this, box2, EntitySelector.LIVING_ENTITY_STILL_ALIVE).stream().filter(entity -> {
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)entity;
                            return HelperMethods.checkFriendlyFire(livingEntity, (LivingEntity)this.ownerEntity);
                        }
                        return false;
                    }).min(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)this))).orElse(null);
                    if (closestEntity != null && closestEntity instanceof LivingEntity && !((le = (LivingEntity)closestEntity) instanceof BattleStandardEntity) && !(le instanceof BattleStandardDarkEntity) && le.distanceTo((Entity)this) > 1.0f && this.onGround()) {
                        this.setDeltaMovement((le.getX() - this.getX()) / 20.0, 0.0, (le.getZ() - this.getZ()) / 20.0);
                    }
                }
                float f = abilityDamage = this.standardType.equals("enigma") ? 1.0f : HelperMethods.spellScaledDamage("soul", (Entity)this.ownerEntity, Config.uniqueEffects.harbinger.spellScaling, Config.uniqueEffects.harbinger.damage);
                if (this.tickCount % 10 == 0) {
                    box = new AABB(this.getX() + (double)radius, this.getY() + (double)((float)radius / 3.0f), this.getZ() + (double)radius, this.getX() - (double)radius, this.getY() - (double)((float)radius / 3.0f), this.getZ() - (double)radius);
                    for (Entity entities : this.level().getEntities((Entity)this, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                        if (!(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, (LivingEntity)this.ownerEntity) || le == this.ownerEntity || le instanceof BattleStandardEntity || le instanceof BattleStandardDarkEntity) continue;
                        le.invulnerableTime = 0;
                        le.hurt(this.damageSources().indirectMagic((Entity)this.ownerEntity, (Entity)this.ownerEntity), abilityDamage);
                        le.invulnerableTime = 0;
                        if (le.distanceTo((Entity)this) > (float)(radius - 1)) {
                            le.setDeltaMovement((this.getX() - le.getX()) / 4.0, (this.getY() - le.getY()) / 4.0, (this.getZ() - le.getZ()) / 4.0);
                        }
                        le.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 0), (Entity)this);
                        if (!this.standardType.equals("enigma")) continue;
                        SimplySwordsStatusEffectInstance effect = HelperMethods.incrementSimplySwordsStatusEffect(le, EffectRegistry.getReference(EffectRegistry.PAIN), 60, 1, 49);
                        effect.setSourceEntity((LivingEntity)this.ownerEntity);
                        effect.setAdditionalData(0);
                        le.addEffect((MobEffectInstance)effect);
                    }
                    if (!this.standardType.equals("enigma")) {
                        HelperMethods.spawnParticle(this.level(), (ParticleOptions)ParticleTypes.SCULK_SOUL, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                    }
                }
                if (this.getHealth() > this.getMaxHealth() - 2.0f && this.onGround()) {
                    if (!this.standardType.equals("enigma")) {
                        HelperMethods.spawnParticle(this.level(), (ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX(), this.getY(), this.getZ(), 0.0, 0.3, 0.0);
                        HelperMethods.spawnParticle(this.level(), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                    }
                    box = new AABB(this.getX() + 1.0, this.getY() + 1.0, this.getZ() + 1.0, this.getX() - 1.0, this.getY() - 1.0, this.getZ() - 1.0);
                    for (Entity entity2 : this.level().getEntities((Entity)this, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                        if (!(entity2 instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity2, (LivingEntity)this.ownerEntity) || le == this.ownerEntity) continue;
                        le.hurt(this.damageSources().indirectMagic((Entity)this.ownerEntity, (Entity)this.ownerEntity), abilityDamage * 3.0f);
                        le.setDeltaMovement((le.getX() - this.getX()) / 4.0, 0.5, (le.getZ() - this.getZ()) / 4.0);
                    }
                }
                if (this.tickCount % 80 == 0 && !this.standardType.equals("enigma")) {
                    box = new AABB(this.getX() + (double)radius, this.getY() + (double)((float)radius / 3.0f), this.getZ() + (double)radius, this.getX() - (double)radius, this.getY() - (double)((float)radius / 3.0f), this.getZ() - (double)radius);
                    for (Entity entity2 : this.level().getEntities((Entity)this, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                        if (!(entity2 instanceof LivingEntity) || HelperMethods.checkFriendlyFire(le = (LivingEntity)entity2, (LivingEntity)this.ownerEntity)) continue;
                        le.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 90, 2), (Entity)this);
                    }
                    this.level().playSound(null, (Entity)this, (SoundEvent)SoundRegistry.DARK_SWORD_WHOOSH_01.get(), this.getSoundSource(), 0.1f, 0.6f);
                    double xpos = this.getX() - (double)(radius + 1);
                    double ypos = this.getY();
                    double zpos = this.getZ() - (double)(radius + 1);
                    for (int i = radius * 2; i > 0; --i) {
                        for (int j = radius * 2; j > 0; --j) {
                            float choose = (float)(Math.random() * 1.0);
                            if (!((double)choose > 0.5)) continue;
                            HelperMethods.spawnParticle(this.level(), (ParticleOptions)ParticleTypes.SOUL, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, -0.1, 0.0);
                        }
                    }
                }
            }
        }
        super.baseTick();
    }
}

