/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import java.util.WeakHashMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.phys.Vec3;

public abstract class OrbitingEffect
extends MobEffect {
    protected ParticleOptions particleType = ParticleTypes.SMOKE;
    private static final WeakHashMap<LivingEntity, AttributeMap> entityAttributeMap = new WeakHashMap();
    private double currentAngle = 0.0;

    public OrbitingEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide) {
            ServerLevel serverWorld = (ServerLevel)livingEntity.level();
            Vec3 center = livingEntity.position().add(0.0, (double)livingEntity.getBbHeight() / 2.0, 0.0);
            double baseRadius = 1.0;
            double speed = 0.39269908169872414;
            for (int i = 0; i <= amplifier; ++i) {
                double radius = baseRadius + (double)i * 0.05;
                double angleOffset = (double)i * 0.7853981633974483;
                double verticalOffset = center.y;
                if (amplifier > 2) {
                    verticalOffset = livingEntity.position().y + Math.min((double)i * 0.4, 3.0);
                }
                if (amplifier > 2) {
                    radius = 0.3 + (double)i * 0.1;
                }
                double x = center.x + radius * Math.cos(this.currentAngle + angleOffset);
                double z = center.z + radius * Math.sin(this.currentAngle + angleOffset);
                double y = verticalOffset;
                serverWorld.sendParticles(this.particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.currentAngle += speed;
            if (this.currentAngle >= Math.PI * 2) {
                this.currentAngle -= Math.PI * 2;
            }
        }
        return true;
    }

    protected void setParticleType(ParticleOptions particleType) {
        this.particleType = particleType;
    }

    public void removeAttributeModifiers(AttributeMap attributes) {
        super.removeAttributeModifiers(attributes);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration > 0;
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        super.onEffectStarted(entity, amplifier);
        entityAttributeMap.put(entity, entity.getAttributes());
    }

    protected LivingEntity getEntityFromAttributeContainer(AttributeMap attributeContainer) {
        for (LivingEntity entity : entityAttributeMap.keySet()) {
            if (entity.getAttributes() != attributeContainer) continue;
            return entity;
        }
        return null;
    }
}

