/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FatalFlickerEffect
extends MobEffect {
    public FatalFlickerEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public static void performDash(LivingEntity user, Level world, int radius) {
        LivingEntity le;
        float dashDistance = Config.uniqueEffects.whisperwind.dashVelocity;
        int maxAmplifier = Config.uniqueEffects.whisperwind.maxStacks;
        int amplifier = 1;
        user.setDeltaMovement(user.getLookAngle().scale((double)dashDistance));
        user.setDeltaMovement(user.getDeltaMovement().x, 0.0, user.getDeltaMovement().z);
        user.hurtMarked = true;
        user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 10, 3), (Entity)user);
        user.invulnerableTime = 25;
        AABB box = HelperMethods.createBox((Entity)user, radius);
        List entities = world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user)) continue;
            ++amplifier;
        }
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user)) continue;
            HelperMethods.incrementStatusEffect(le, EffectRegistry.getReference(EffectRegistry.ECHO), 20, amplifier, maxAmplifier);
        }
        AABB boxPull = HelperMethods.createBox((Entity)user, radius * 2);
        for (Entity entity : world.getEntities((Entity)user, boxPull, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
            LivingEntity le2;
            if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le2 = (LivingEntity)entity, user)) continue;
            le2.setDeltaMovement((user.getX() - le2.getX()) / 4.0, (user.getY() - le2.getY()) / 4.0, (user.getZ() - le2.getZ()) / 4.0);
        }
    }

    public boolean applyEffectTick(LivingEntity user, int amplifier) {
        super.applyEffectTick(user, amplifier);
        if (!user.level().isClientSide()) {
            int ability_timer = Objects.requireNonNull(user.getEffect(EffectRegistry.getReference(EffectRegistry.FATAL_FLICKER))).getDuration();
            Level world = user.level();
            int radius = Config.uniqueEffects.whisperwind.radius;
            if (ability_timer >= 5) {
                FatalFlickerEffect.performDash(user, world, radius);
            } else {
                user.setDeltaMovement(0.0, 0.0, 0.0);
                user.hurtMarked = true;
            }
            if (user.tickCount % 2 == 0) {
                int particleRadius = (int)((double)radius * 0.5);
                double xpos = user.getX() - (double)(particleRadius + 1);
                double ypos = user.getY();
                double zpos = user.getZ() - (double)(particleRadius + 1);
                for (int i = particleRadius * 2; i > 0; --i) {
                    for (int j = particleRadius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.CLOUD, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.WARPED_SPORE, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                    }
                }
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

