/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class AstralShiftEffect
extends MobEffect {
    public AstralShiftEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide()) {
            MobEffectInstance effectInstance;
            Player player;
            ServerLevel world = (ServerLevel)entity.level();
            if (entity instanceof Player && (player = (Player)entity).hasEffect(EffectRegistry.getReference(EffectRegistry.ASTRAL_SHIFT)) && (effectInstance = player.getEffect(EffectRegistry.getReference(EffectRegistry.ASTRAL_SHIFT))) != null && effectInstance.getDuration() < 10) {
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                float damageMulti = Config.uniqueEffects.caelestis.damageModifier;
                float damageMax = Config.uniqueEffects.caelestis.damageMax;
                double radius = 8.0;
                float damage = Math.min((float)amplifier * damageMulti, damageMax);
                world.playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.DARK_ACTIVATION_DISTORTED.get(), entity.getSoundSource(), 0.5f, 1.1f);
                DamageSource damageSource = entity.damageSources().playerAttack(player);
                AABB box = new AABB(x - radius, y - 1.0, z - radius, x + radius, y + 1.0, z + radius);
                List nearbyEntities = world.getEntities((Entity)entity, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE);
                for (Entity nearbyEntity : nearbyEntities) {
                    LivingEntity target;
                    if (!(nearbyEntity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(target = (LivingEntity)nearbyEntity, (LivingEntity)player)) continue;
                    if (target instanceof Player) {
                        damageSource = entity.damageSources().playerAttack(player);
                    }
                    target.invulnerableTime = 0;
                    HelperMethods.applyDamageWithoutKnockback(target, damageSource, damage);
                    target.invulnerableTime = 0;
                    HelperMethods.spawnRainingParticles(world, (ParticleOptions)ParticleTypes.ENCHANT, (Entity)target, 4, 2.0);
                    HelperMethods.spawnRainingParticles(world, (ParticleOptions)ParticleTypes.WARPED_SPORE, (Entity)target, 4, 2.0);
                    HelperMethods.spawnOrbitParticles(world, target.position(), (ParticleOptions)ParticleTypes.WARPED_SPORE, 0.5, 6);
                    HelperMethods.spawnWaistHeightParticles(world, (ParticleOptions)ParticleTypes.SMOKE, (Entity)player, (Entity)target, 15);
                    HelperMethods.spawnRainingParticles(world, (ParticleOptions)ParticleTypes.EXPLOSION, (Entity)target, 2, 1.0);
                }
                entity.removeEffect(EffectRegistry.getReference(EffectRegistry.ASTRAL_SHIFT));
            }
        }
        super.applyEffectTick(entity, amplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

