/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.client.util;

import dev.architectury.platform.Platform;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.sweenus.simplyswords.SimplySwordsExpectPlatform;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.client.util.EmiUtils;
import net.sweenus.simplyswords.client.util.OracleIndexUtils;
import net.sweenus.simplyswords.client.util.ReiUtils;
import net.sweenus.simplyswords.power.GemPower;
import net.sweenus.simplyswords.power.GemPowerComponent;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class TooltipUtils {
    public static final ResourceLocation runic_tags = ResourceLocation.fromNamespaceAndPath((String)"simplyswords", (String)"runic_weapons");
    private static long ctrlKeyPressTimestamp = 0L;

    public static void centerAlignTooltip(List<Component> tooltip, Component text) {
        Minecraft client = Minecraft.getInstance();
        int tooltipWidth = 0;
        for (Component line : tooltip) {
            tooltipWidth = Math.max(tooltipWidth, client.font.width((FormattedText)line));
        }
        int textWidth = client.font.width((FormattedText)text);
        int paddingWidth = (tooltipWidth - textWidth) / 2;
        String padding = " ".repeat(Math.max(0, paddingWidth / client.font.width(" ")));
        tooltip.add((Component)Component.literal((String)padding).append(text));
    }

    public static void addDynamicButtonTooltip(List<Component> tooltip, Component info, Component search, Component config, boolean isAlt, boolean isCtrl) {
        boolean isAltAndCtrl = isAlt && isCtrl;
        tooltip.add((Component)Component.literal((String)"").append((Component)info.copy().setStyle(info.getStyle().withColor(isAltAndCtrl ? Styles.COMMON.getColor() : (isAlt ? Styles.UNIQUE.getColor() : Styles.COMMON.getColor())))).append("\u00a0").append((Component)search.copy().setStyle(search.getStyle().withColor(isAltAndCtrl ? Styles.COMMON.getColor() : (isCtrl ? Styles.UNIQUE.getColor() : Styles.COMMON.getColor())))).append("\u00a0").append((Component)config.copy().setStyle(config.getStyle().withColor(isAltAndCtrl ? Styles.UNIQUE.getColor() : Styles.COMMON.getColor()))));
    }

    public static void appendSpellScaleTooltip(List<Component> tooltip, String spellSchool) {
        if ((Platform.isModLoaded((String)"spell_power") || Platform.isModLoaded((String)"irons_spellbooks")) && Screen.hasAltDown() && !Screen.hasControlDown()) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.compat.spellScaling").setStyle(Styles.COMMON));
            switch (spellSchool) {
                case "fire": {
                    tooltip.add((Component)Component.literal((String)"\uab42").append((Component)Component.translatable((String)"item.simplyswords.compat.scaleFire")));
                    break;
                }
                case "frost": {
                    tooltip.add((Component)Component.literal((String)"\uab43").append((Component)Component.translatable((String)"item.simplyswords.compat.scaleFrost")));
                    break;
                }
                case "lightning": {
                    tooltip.add((Component)Component.literal((String)"\uab44").append((Component)Component.translatable((String)"item.simplyswords.compat.scaleLightning")));
                    break;
                }
                case "soul": {
                    tooltip.add((Component)Component.literal((String)"\uab45").append((Component)Component.translatable((String)"item.simplyswords.compat.scaleSoul")));
                    break;
                }
                case "arcane": {
                    tooltip.add((Component)Component.literal((String)"\uab46").append((Component)Component.translatable((String)"item.simplyswords.compat.scaleArcane")));
                    break;
                }
                case "frost_fire": {
                    tooltip.add((Component)Component.literal((String)"\uab43").append((Component)Component.translatable((String)"item.simplyswords.compat.scaleFrost")).append((Component)Component.literal((String)"   \uab42")).append((Component)Component.translatable((String)"item.simplyswords.compat.scaleFire")));
                    break;
                }
                case "healing_fire": {
                    tooltip.add((Component)Component.literal((String)"\uab47").append((Component)Component.translatable((String)"item.simplyswords.compat.scaleHealing")).append((Component)Component.literal((String)"   \uab42")).append((Component)Component.translatable((String)"item.simplyswords.compat.scaleFire")));
                }
            }
            tooltip.add((Component)Component.literal((String)""));
        }
    }

    public static boolean shouldDisplayTooltip(ItemStack stack, ResourceLocation tagId) {
        return Screen.hasAltDown() && !Screen.hasControlDown() || HelperMethods.isInTag(stack, tagId) || stack.is((Item)ItemsRegistry.RUNEFUSED_GEM.get()) || stack.is((Item)ItemsRegistry.NETHERFUSED_GEM.get());
    }

    public static void openPatchouli(ResourceLocation entry) {
        if (Platform.isModLoaded((String)"patchouli")) {
            if (entry.getPath().contains("lichblade")) {
                entry = ResourceLocation.parse((String)"simplyswords:uniques/entry_slumbering_lichblade");
            }
            if (entry.getPath().contains("righteous_relic")) {
                entry = ResourceLocation.parse((String)"simplyswords:uniques/entry_dormant_relic");
            }
            if (entry.getPath().contains("tainted_relic")) {
                entry = ResourceLocation.parse((String)"simplyswords:uniques/entry_dormant_relic");
            }
            TooltipUtils.commonPatchouli(entry);
        }
    }

    public static void openFzzyConfig(String path) {
        if (!ConfigApiJava.isScreenOpen((String)"simplyswords.unique_effects.")) {
            ConfigApiJava.INSTANCE.openScreen(path);
        }
    }

    public static ResourceLocation generateDefaultTooltipEntry(ItemStack itemStack, String itemPath) {
        return ResourceLocation.parse((String)(itemPath + "/" + itemStack.getItem().builtInRegistryHolder().key().location().getPath() + ".mdx"));
    }

    public static ResourceLocation handleUniqueSwordTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, String uniquePath) {
        tooltip.add((Component)Component.literal((String)""));
        SimplySwordsAPI.appendTooltipGemSocketLogic(itemStack, tooltipContext, tooltip, type);
        return ResourceLocation.parse((String)(uniquePath + "/" + itemStack.getItem().builtInRegistryHolder().key().location().getPath() + ".mdx"));
    }

    public static ResourceLocation handleRunicSwordTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, String modId, String itemPath, String runicPath) {
        tooltip.add((Component)Component.literal((String)""));
        GemPowerComponent component = SimplySwordsAPI.getComponent(itemStack);
        if (component.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.unidentifiedsworditem.tooltip1").setStyle(Styles.RUNIC));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.unidentifiedsworditem.tooltip2").setStyle(Styles.TEXT));
        } else {
            component.appendTooltip(itemStack, tooltipContext, tooltip, type, true);
            if (!Platform.isNeoForge()) {
                Holder<GemPower> mainComponent = component.runicPower();
                String powerId = mainComponent.getRegisteredName().replace(modId + ":", "").replace("greater_", "");
                return ResourceLocation.parse((String)(runicPath + "/" + powerId + ".mdx"));
            }
        }
        return TooltipUtils.generateDefaultTooltipEntry(itemStack, itemPath);
    }

    public static void processCtrlAltNavigation(ResourceLocation entry, String modId, ResourceLocation customConfigPath, ItemStack itemStack, List<Component> tooltip) {
        if (Screen.hasControlDown()) {
            if (ctrlKeyPressTimestamp == 0L) {
                ctrlKeyPressTimestamp = System.currentTimeMillis();
            }
            if (!(Platform.isModLoaded((String)"oracle_index") || Platform.isModLoaded((String)"roughlyenoughitems") || Platform.isModLoaded((String)"emi"))) {
                tooltip.add((Component)Component.translatable((String)"message.simplyswords.documentation.error").setStyle(Styles.TEXT));
                tooltip.add((Component)Component.translatable((String)"message.simplyswords.documentation.error2").setStyle(Styles.TEXT));
            }
            if (System.currentTimeMillis() - ctrlKeyPressTimestamp >= 500L) {
                if (Screen.hasAltDown()) {
                    if (customConfigPath == null) {
                        TooltipUtils.openFzzyConfig(modId);
                    } else {
                        String customPath = customConfigPath.getPath().replace(modId + ":", "");
                        TooltipUtils.openFzzyConfig(customPath);
                    }
                } else if (Platform.isModLoaded((String)"oracle_index")) {
                    OracleIndexUtils.openOracleIndex(entry, modId);
                } else if (Platform.isModLoaded((String)"roughlyenoughitems")) {
                    ReiUtils.openRei(entry, modId, itemStack);
                } else if (Platform.isModLoaded((String)"emi")) {
                    EmiUtils.openEmi(entry, modId, itemStack);
                }
                ctrlKeyPressTimestamp = 0L;
            }
        } else {
            ctrlKeyPressTimestamp = 0L;
        }
    }

    public static void commonPatchouli(ResourceLocation entry) {
        SimplySwordsExpectPlatform.openPatchouli(entry);
    }
}

