/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.sweenus.simplyswords.entity.ThrownSwordEntity;
import net.sweenus.simplyswords.item.custom.LivyatanSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;

public class ThrownSwordEntityRenderer
extends EntityRenderer<ThrownSwordEntity> {
    private final ItemRenderer itemRenderer;

    public ThrownSwordEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(ThrownSwordEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        ItemStack swordStack = entity.getPickupItemStackOrigin();
        if (swordStack == null || swordStack.isEmpty()) {
            swordStack = ((LivyatanSwordItem)((Object)ItemsRegistry.LIVYATAN.get())).getDefaultInstance();
        }
        if (swordStack != null && !swordStack.isEmpty()) {
            matrices.pushPose();
            matrices.translate(0.0, 0.5, 0.0);
            matrices.scale(1.0f, 1.0f, 1.0f);
            matrices.mulPose(Axis.YP.rotationDegrees(-entity.getYRot()));
            matrices.mulPose(Axis.ZP.rotationDegrees(-entity.getXRot()));
            BakedModel model = this.itemRenderer.getItemModelShaper().getItemModel(swordStack);
            this.itemRenderer.render(swordStack, ItemDisplayContext.GROUND, false, matrices, vertexConsumers, light, 0, model);
            matrices.translate(0.0, 0.25, 0.0);
            matrices.popPose();
        }
        super.render((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public ResourceLocation getTexture(ThrownSwordEntity entity) {
        return null;
    }
}

