/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common;

import com.simibubi.create.foundation.item.ItemDescription;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.dragons.createdragonsplus.common.CDPRegistrate;
import plus.dragons.createintegratedfarming.common.registry.CIFArmInteractionPoints;
import plus.dragons.createintegratedfarming.common.registry.CIFBlockEntities;
import plus.dragons.createintegratedfarming.common.registry.CIFBlockSpoutingBehaviours;
import plus.dragons.createintegratedfarming.common.registry.CIFBlocks;
import plus.dragons.createintegratedfarming.common.registry.CIFCreativeModeTabs;
import plus.dragons.createintegratedfarming.common.registry.CIFDataMaps;
import plus.dragons.createintegratedfarming.common.registry.CIFRoostCapturables;
import plus.dragons.createintegratedfarming.config.CIFConfig;
import plus.dragons.createintegratedfarming.integration.ModIntegration;

@Mod(value="create_integrated_farming")
public class CIFCommon {
    public static final String ID = "create_integrated_farming";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Create: Integrated Farming");
    public static final CDPRegistrate REGISTRATE = new CDPRegistrate("create_integrated_farming").setTooltipModifier(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE));

    public CIFCommon(IEventBus modBus, ModContainer modContainer) {
        REGISTRATE.registerEventListeners(modBus);
        CIFCreativeModeTabs.register(modBus);
        CIFBlocks.register(modBus);
        CIFBlockEntities.register(modBus);
        CIFArmInteractionPoints.register(modBus);
        CIFDataMaps.register(modBus);
        modBus.register((Object)this);
        modBus.register((Object)new CIFConfig(modContainer));
    }

    @SubscribeEvent
    public void onConstructMod(FMLConstructModEvent event) {
        for (ModIntegration integration : ModIntegration.values()) {
            if (!integration.enabled()) continue;
            event.enqueueWork(integration::onConstructMod);
        }
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(CIFBlockSpoutingBehaviours::register);
        event.enqueueWork(CIFRoostCapturables::register);
        for (ModIntegration integration : ModIntegration.values()) {
            if (!integration.enabled()) continue;
            event.enqueueWork(integration::onCommonSetup);
        }
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        for (ModIntegration integration : ModIntegration.values()) {
            if (!integration.enabled()) continue;
            event.enqueueWork(integration::onClientSetup);
        }
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }
}

