/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.mixin;

import com.izofar.takesapillage.common.init.ItTakesPillageEntityTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.GolemSensor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GolemSensor.class})
public abstract class ClayGolemSensorMixin {
    @Inject(method={"doTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="RETURN")})
    private void takesapillage$doTick(ServerLevel serverLevel, LivingEntity livingEntity, CallbackInfo ci) {
        ClayGolemSensorMixin.takesapillage$checkForNearbyClayGolem(livingEntity);
    }

    private static void takesapillage$checkForNearbyClayGolem(LivingEntity livingEntity) {
        boolean flag;
        Optional optional = livingEntity.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES);
        if (optional.isPresent() && (flag = ((List)optional.get()).stream().anyMatch(target -> target.getType().equals(ItTakesPillageEntityTypes.CLAY_GOLEM.get())))) {
            GolemSensor.golemDetected((LivingEntity)livingEntity);
        }
    }
}

