/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.entity.ai;

import com.izofar.takesapillage.common.entity.ShieldedMob;
import java.util.EnumSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ShieldGoal<T extends Mob>
extends Goal {
    protected final Class<? extends LivingEntity> targetType;
    protected final T mob;
    private int shieldCoolDown;
    private int shieldWarmup;
    private int shieldStagger;
    private int shieldDelay;
    @Nullable
    protected LivingEntity target;
    protected final TargetingConditions targetConditions;

    public ShieldGoal(T mob, Class<? extends LivingEntity> targetType) {
        this.mob = mob;
        this.targetType = targetType;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.forCombat().range(this.getFollowDistance()).selector(null);
    }

    public boolean canUse() {
        this.findTarget();
        return this.target != null;
    }

    public boolean canContinueToUse() {
        if (((ShieldedMob)this.mob).isShieldDisabled()) {
            return false;
        }
        if (this.target == null) {
            return false;
        }
        if (!this.target.isAlive()) {
            return false;
        }
        if (this.mob.distanceToSqr((Entity)this.target) > this.getFollowDistance() * this.getFollowDistance()) {
            return false;
        }
        return this.getStage() != ShieldStage.INACTIVE;
    }

    public void start() {
        this.mob.setTarget(this.target);
        this.shieldDelay = this.adjustedTickDelay(3 + this.mob.getRandom().nextInt(3));
        this.shieldStagger = this.adjustedTickDelay(15 + this.mob.getRandom().nextInt(25));
        this.setDefaultCounters();
        super.start();
    }

    public void stop() {
        this.target = null;
        this.setDefaultCounters();
        ((ShieldedMob)this.mob).stopUsingShield();
    }

    public void tick() {
        switch (this.getStage().ordinal()) {
            case 0: {
                this.setDefaultCounters();
                break;
            }
            case 1: {
                --this.shieldWarmup;
                break;
            }
            case 2: {
                if (this.mob.getTarget() == null) {
                    return;
                }
                this.mob.getLookControl().setLookAt(this.mob.getTarget().getX(), this.mob.getTarget().getEyeY(), this.mob.getTarget().getZ(), 10.0f, (float)this.mob.getMaxHeadXRot());
                ((ShieldedMob)this.mob).startUsingShield();
                this.setDefaultCounters();
                break;
            }
            case 3: {
                --this.shieldCoolDown;
            }
        }
    }

    private static boolean targetDrawnBow(LivingEntity target) {
        if (target == null) {
            return false;
        }
        for (InteractionHand interactionhand : InteractionHand.values()) {
            boolean chargedCrossbow;
            ItemStack itemstack = target.getItemInHand(interactionhand);
            boolean drawnBow = itemstack.is(Items.BOW) && target.isUsingItem();
            boolean bl = chargedCrossbow = itemstack.is(Items.CROSSBOW) && CrossbowItem.isCharged((ItemStack)itemstack);
            if (!drawnBow && !chargedCrossbow) continue;
            return true;
        }
        return false;
    }

    protected AABB getTargetSearchArea(double radius) {
        return this.mob.getBoundingBox().inflate(radius, 4.0, radius);
    }

    protected void findTarget() {
        Object potentialTarget = this.targetType != Player.class && this.targetType != ServerPlayer.class ? this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(this.targetType, this.getTargetSearchArea(this.getFollowDistance()), p_148152_ -> true), this.targetConditions, this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ()) : this.mob.level().getNearestPlayer(this.mob.getX(), this.mob.getEyeY(), this.mob.getZ(), this.getFollowDistance(), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        this.target = ShieldGoal.targetDrawnBow((LivingEntity)potentialTarget) ? potentialTarget : null;
    }

    protected double getFollowDistance() {
        return this.mob.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    private void setDefaultCounters() {
        this.shieldWarmup = this.shieldDelay;
        this.shieldCoolDown = this.shieldStagger;
    }

    private ShieldStage getStage() {
        if (ShieldGoal.targetDrawnBow(this.target)) {
            if (this.shieldWarmup <= 0) {
                this.shieldWarmup = 0;
                return ShieldStage.ACTIVE;
            }
            return ShieldStage.WARMUP;
        }
        if (this.shieldCoolDown <= 0) {
            this.shieldCoolDown = 0;
            return ShieldStage.INACTIVE;
        }
        return ShieldStage.COOLDOWN;
    }

    private static enum ShieldStage {
        INACTIVE,
        WARMUP,
        ACTIVE,
        COOLDOWN;

    }
}

