/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.entity;

import com.izofar.takesapillage.common.ItTakesPillage;
import com.izofar.takesapillage.common.entity.ShieldedMob;
import com.izofar.takesapillage.common.entity.ai.ShieldGoal;
import com.izofar.takesapillage.common.init.ItTakesPillageSoundEvents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public final class Legioner
extends AbstractIllager
implements ShieldedMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_SHIELDED = SynchedEntityData.defineId(Legioner.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SHIELD_HAND = SynchedEntityData.defineId(Legioner.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_SHIELD_COOLDOWN = SynchedEntityData.defineId(Legioner.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final AttributeModifier SPEED_MODIFIER_BLOCKING = new AttributeModifier(ItTakesPillage.makeId("speed_modifier_attacking"), -0.1, AttributeModifier.Operation.ADD_VALUE);

    public Legioner(EntityType<? extends AbstractIllager> entitytype, Level world) {
        super(entitytype, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.275).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ATTACK_DAMAGE, 6.5).add(Attributes.ARMOR, 6.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, new ShieldGoal<Legioner>(this, Player.class));
        this.goalSelector.addGoal(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_SHIELDED, (Object)false);
        builder.define(DATA_SHIELD_HAND, (Object)false);
        builder.define(DATA_SHIELD_COOLDOWN, (Object)0);
    }

    public void tick() {
        if (!ItTakesPillage.getConfig().enableLegioner) {
            this.discard();
        }
        super.tick();
        if (!this.level().isClientSide) {
            this.decrementShieldCooldown();
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        SpawnGroupData spawngroupdata = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        RandomSource randomSource = world.getRandom();
        this.populateDefaultEquipmentSlots(randomSource, difficulty);
        this.populateDefaultEquipmentEnchantments(world, randomSource, difficulty);
        return spawngroupdata;
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomsource, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isAggressive()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.isCelebrating() ? AbstractIllager.IllagerArmPose.CELEBRATING : null;
    }

    public void applyRaidBuffs(ServerLevel serverLevel, int i, boolean bl) {
    }

    public void knockback(double x, double y, double z) {
        if (!this.isUsingShield()) {
            super.knockback(x, y, z);
        } else {
            SoundEvent soundEvent = SoundEvents.SHIELD_BLOCK;
            this.playSound(soundEvent, 1.0f, 0.8f + this.level().random.nextFloat() * 0.4f);
        }
    }

    protected void blockUsingShield(LivingEntity attacker) {
        super.blockUsingShield(attacker);
        if (attacker.getMainHandItem().getItem() instanceof AxeItem) {
            this.disableShield();
        }
    }

    private void disableShield() {
        this.setShieldCooldown(60);
        this.stopUsingShield();
        this.level().broadcastEntityEvent((Entity)this, (byte)30);
        SoundEvent soundEvent = SoundEvents.SHIELD_BREAK;
        this.playSound(soundEvent, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
    }

    @Override
    public boolean isShieldDisabled() {
        return this.getShieldCooldown() > 0;
    }

    @Override
    public void startUsingShield() {
        if (this.isUsingShield() || this.isShieldDisabled()) {
            return;
        }
        for (InteractionHand interactionhand : InteractionHand.values()) {
            if (!this.getItemInHand(interactionhand).is(Items.SHIELD)) continue;
            this.startUsingItem(interactionhand);
            this.setUsingShield(true);
            this.setShieldMainhand(interactionhand == InteractionHand.MAIN_HAND);
            AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributeinstance == null || attributeinstance.hasModifier(SPEED_MODIFIER_BLOCKING.id())) continue;
            attributeinstance.addTransientModifier(SPEED_MODIFIER_BLOCKING);
        }
    }

    @Override
    public void stopUsingShield() {
        if (!this.isUsingShield()) {
            return;
        }
        for (InteractionHand interactionhand : InteractionHand.values()) {
            if (!this.getItemInHand(interactionhand).is(Items.SHIELD)) continue;
            this.stopUsingItem();
            this.setUsingShield(false);
            AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributeinstance == null) continue;
            attributeinstance.removeModifier(SPEED_MODIFIER_BLOCKING);
        }
    }

    public boolean isUsingShield() {
        return (Boolean)this.entityData.get(DATA_IS_SHIELDED);
    }

    public void setUsingShield(boolean isShielded) {
        this.entityData.set(DATA_IS_SHIELDED, (Object)isShielded);
    }

    private boolean isShieldMainhand() {
        return (Boolean)this.entityData.get(DATA_SHIELD_HAND);
    }

    private void setShieldMainhand(boolean isShieldedMainHand) {
        this.entityData.set(DATA_SHIELD_HAND, (Object)isShieldedMainHand);
    }

    private int getShieldCooldown() {
        return (Integer)this.entityData.get(DATA_SHIELD_COOLDOWN);
    }

    private void setShieldCooldown(int newShieldCooldown) {
        this.entityData.set(DATA_SHIELD_COOLDOWN, (Object)newShieldCooldown);
    }

    private void decrementShieldCooldown() {
        this.setShieldCooldown(Math.max(this.getShieldCooldown() - 1, 0));
    }

    public InteractionHand getShieldHand() {
        return this.isUsingShield() ? (this.isShieldMainhand() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND) : null;
    }

    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ItTakesPillageSoundEvents.LEGIONER_CELEBRATE.get();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ItTakesPillageSoundEvents.LEGIONER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ItTakesPillageSoundEvents.LEGIONER_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_33306_) {
        return (SoundEvent)ItTakesPillageSoundEvents.LEGIONER_HURT.get();
    }
}

