/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common;

import com.izofar.takesapillage.common.config.ItTakesPillageConfig;
import com.izofar.takesapillage.common.entity.event.IronGolemOnEntitySpawn;
import com.izofar.takesapillage.common.event.AddItemGroupEntriesEvent;
import com.izofar.takesapillage.common.event.entity.EntitySpawnEvent;
import com.izofar.takesapillage.common.event.entity.RegisterEntityAttributesEvent;
import com.izofar.takesapillage.common.event.lifecycle.ServerLevelTickEvent;
import com.izofar.takesapillage.common.init.ItTagesPillageTags;
import com.izofar.takesapillage.common.init.ItTakesPillageEntityTypes;
import com.izofar.takesapillage.common.init.ItTakesPillageFeatures;
import com.izofar.takesapillage.common.init.ItTakesPillageInstruments;
import com.izofar.takesapillage.common.init.ItTakesPillageItemGroups;
import com.izofar.takesapillage.common.init.ItTakesPillageItems;
import com.izofar.takesapillage.common.init.ItTakesPillageSoundEvents;
import com.izofar.takesapillage.common.init.ItTakesPillageStructureTypes;
import com.izofar.takesapillage.common.world.PillageSiege;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItTakesPillage {
    public static final String MOD_ID = "takesapillage";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final ItTakesPillageConfig CONFIG = new ItTakesPillageConfig();

    public static ItTakesPillageConfig getConfig() {
        return (ItTakesPillageConfig)ItTakesPillageConfig.HANDLER.instance();
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static ResourceLocation makeId(String path) {
        return ItTakesPillage.makeId(MOD_ID, path);
    }

    public static ResourceLocation makeId(String id, String path) {
        return ResourceLocation.tryBuild((String)id, (String)path);
    }

    public static ResourceLocation makeVanillaId(String id) {
        return ResourceLocation.parse((String)id);
    }

    public static void init() {
        ItTakesPillage.getConfig().load();
        ItTagesPillageTags.init();
        ItTakesPillageEntityTypes.ENTITY_TYPES.init();
        ItTakesPillageFeatures.FEATURES.init();
        ItTakesPillageInstruments.INSTRUMENTS.init();
        ItTakesPillageItemGroups.ITEM_GROUPS.init();
        ItTakesPillageItems.ITEMS.init();
        ItTakesPillageSoundEvents.SOUND_EVENTS.init();
        ItTakesPillageStructureTypes.STRUCTURE_TYPES.init();
        EntitySpawnEvent.EVENT.addListener(IronGolemOnEntitySpawn::handleEntitySpawn);
        RegisterEntityAttributesEvent.EVENT.addListener(ItTakesPillageEntityTypes::registerEntityAttributes);
        ServerLevelTickEvent.EVENT.addListener(ItTakesPillage::registerPillageSiege);
        AddItemGroupEntriesEvent.EVENT.addListener(ItTakesPillageItemGroups::addItemGroupEntries);
    }

    private static void registerPillageSiege(ServerLevelTickEvent event) {
        Level level;
        if (event.end() && (level = event.getLevel()) != null && ((ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && level.dimension() == Level.OVERWORLD) {
            PillageSiege.PILLAGE_SIEGE.tick((ServerLevel)level, true, false);
        }
    }
}

