/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.baguettelib.mixin;

import com.leclowndu93150.baguettelib.event.entity.death.PlayerDeathEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class}, priority=500)
public class PlayerDeathMixin {
    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPreDeath(DamageSource damageSource, CallbackInfo ci) {
        Player self = (Player)this;
        if (self.isRemoved()) {
            return;
        }
        PlayerDeathEvent.Pre event = new PlayerDeathEvent.Pre(self, damageSource);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"die"}, at={@At(value="TAIL")})
    private void onPostDeath(DamageSource damageSource, CallbackInfo ci) {
        Player self = (Player)this;
        if (self.isRemoved()) {
            return;
        }
        NeoForge.EVENT_BUS.post((Event)new PlayerDeathEvent.Post(self, damageSource));
    }
}

