/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.utils;

import com.pedrorok.hypertube.blocks.blockentities.HypertubeBlockEntity;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.placement.ResponseDTO;
import com.pedrorok.hypertube.items.HypertubeItem;
import com.pedrorok.hypertube.registry.ModBlocks;
import com.pedrorok.hypertube.registry.ModDataComponent;
import com.pedrorok.hypertube.utils.MessageUtils;
import com.pedrorok.hypertube.utils.RayCastUtils;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TubeUtils {
    private static final float CHECK_DISTANCE_THRESHOLD = 0.4f;

    public static ResponseDTO checkClickedHypertube(Level level, BlockPos pos, Direction direction) {
        HypertubeBlockEntity tubeEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HypertubeBlockEntity && !(tubeEntity = (HypertubeBlockEntity)blockEntity).getFacesConnectable().contains(direction)) {
            return ResponseDTO.invalid("placement.create_hypertube.cant_conn_to_face");
        }
        return ResponseDTO.get(true);
    }

    public static boolean checkPlayerPlacingBlock(@NotNull Player player, Level level, BlockPos pos) {
        ItemStack itemInHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemInHand.getItem() != ModBlocks.HYPERTUBE.asItem()) {
            return true;
        }
        if (!itemInHand.hasFoil()) {
            return true;
        }
        SimpleConnection connectionFrom = (SimpleConnection)itemInHand.get(ModDataComponent.TUBE_CONNECTING_FROM);
        Direction finalDirection = RayCastUtils.getDirectionFromHitResult(player, null, true);
        SimpleConnection connectionTo = new SimpleConnection(pos, finalDirection);
        BezierConnection bezierConnection = BezierConnection.of(connectionFrom, connectionTo);
        return TubeUtils.checkPlayerPlacingBlockValidation(player, bezierConnection, level);
    }

    public static boolean checkPlayerPlacingBlockValidation(Player player, @NotNull BezierConnection bezierConnection, Level level) {
        ResponseDTO validation = bezierConnection.getValidation();
        if (validation.valid()) {
            validation = TubeUtils.checkSurvivalItems(player, (int)bezierConnection.distance(), true);
        }
        if (validation.valid()) {
            validation = TubeUtils.checkBlockCollision(level, bezierConnection);
        }
        if (!validation.valid()) {
            MessageUtils.sendActionMessage(player, (Component)validation.getMessageComponent());
            return false;
        }
        HypertubeItem.clearConnection(player.getItemInHand(InteractionHand.MAIN_HAND));
        TubeUtils.checkSurvivalItems(player, (int)bezierConnection.distance() + 1, false);
        return true;
    }

    public static ResponseDTO checkBlockCollision(@NotNull Level level, @NotNull BezierConnection bezierConnection) {
        ArrayList positions = new ArrayList(bezierConnection.getBezierPoints().reversed());
        positions.removeLast();
        positions.removeFirst();
        for (int i = 1; i < positions.size() - 1; ++i) {
            Vec3 pos = (Vec3)positions.get(i);
            if (!TubeUtils.hasCollision(level, pos) && !TubeUtils.hasCollision(level, pos.add((double)0.4f, 0.0, 0.0)) && !TubeUtils.hasCollision(level, pos.add(0.0, 0.0, (double)0.4f)) && !TubeUtils.hasCollision(level, pos.add((double)0.4f, 0.0, (double)0.4f)) && !TubeUtils.hasCollision(level, pos.add((double)-0.4f, 0.0, 0.0)) && !TubeUtils.hasCollision(level, pos.add(0.0, 0.0, (double)-0.4f)) && !TubeUtils.hasCollision(level, pos.add((double)-0.4f, 0.0, (double)-0.4f))) continue;
            return ResponseDTO.invalid("placement.create_hypertube.block_collision");
        }
        return ResponseDTO.get(true);
    }

    private static boolean hasCollision(Level level, Vec3 pos) {
        boolean hasCollision;
        BlockPos blockPos = BlockPos.containing((Position)pos);
        boolean bl = hasCollision = !level.getBlockState(blockPos).getCollisionShape((BlockGetter)level, blockPos).isEmpty();
        if (hasCollision && level.isClientSide) {
            BezierConnection.outlineBlocks(blockPos);
        }
        return hasCollision;
    }

    public static ResponseDTO checkSurvivalItems(@NotNull Player player, int neededTubes, boolean simulate) {
        if (!player.isCreative() && !TubeUtils.checkPlayerInventory(player, neededTubes, simulate)) {
            return ResponseDTO.invalid("placement.create_hypertube.no_enough_tubes");
        }
        return ResponseDTO.get(true);
    }

    private static boolean checkPlayerInventory(@NotNull Player player, int neededTubes, boolean simulate) {
        int foundTubes = 0;
        Inventory inv = player.getInventory();
        int size = inv.items.size();
        for (int j = 0; j <= size + 1; ++j) {
            boolean offhand;
            int i = j;
            boolean bl = offhand = j == size + 1;
            if (j == size) {
                i = inv.selected;
            } else if (offhand) {
                i = 0;
            } else if (j == inv.selected) continue;
            ItemStack stackInSlot = (ItemStack)(offhand ? inv.offhand : inv.items).get(i);
            boolean isTube = ModBlocks.HYPERTUBE.asStack().is(stackInSlot.getItem());
            if (!isTube || foundTubes >= neededTubes) continue;
            int count = stackInSlot.getCount();
            if (!simulate) {
                int remainingItems = count - Math.min(neededTubes - foundTubes, count);
                ItemStack newItem = stackInSlot.copyWithCount(remainingItems);
                if (offhand) {
                    player.setItemInHand(InteractionHand.OFF_HAND, newItem);
                } else {
                    inv.setItem(i, newItem);
                }
            }
            foundTubes += count;
        }
        return foundTubes >= neededTubes;
    }
}

