/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.travel;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.blocks.HyperEntranceBlock;
import com.pedrorok.hypertube.config.ClientConfig;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.pedrorok.hypertube.core.travel.TravelPathData;
import com.pedrorok.hypertube.core.travel.TravelPathMover;
import com.pedrorok.hypertube.events.PlayerSyncEvents;
import com.pedrorok.hypertube.network.packets.MovePathPacket;
import com.pedrorok.hypertube.network.packets.SyncPersistentDataPacket;
import com.pedrorok.hypertube.utils.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

public class TravelManager {
    private static final Map<UUID, TravelPathMover> travelDataMap = new HashMap<UUID, TravelPathMover>();
    private static boolean isTraveling;

    public static void tryStartTravel(LivingEntity entity, BlockPos pos, BlockState state, float speed) {
        BlockPos relative;
        TravelPathData travelPathData;
        BlockPos lastTravelPos;
        CompoundTag entityPersistentData = entity.getPersistentData();
        if (entityPersistentData.getBoolean("hypertube_travel")) {
            return;
        }
        boolean isPlayer = entity instanceof ServerPlayer;
        ServerPlayer player = isPlayer ? (ServerPlayer)entity : null;
        long lastTravelTime = entityPersistentData.getLong("last_travel_time");
        if (entityPersistentData.contains("last_travel_blockpos") && (lastTravelPos = BlockPos.of((long)entityPersistentData.getLong("last_travel_blockpos"))).equals((Object)pos) && lastTravelTime > System.currentTimeMillis()) {
            return;
        }
        if (lastTravelTime - 1500L > System.currentTimeMillis()) {
            speed += entityPersistentData.getFloat("last_travel_speed");
        }
        if ((travelPathData = new TravelPathData(relative = pos.relative((Direction)state.getValue((Property)HyperEntranceBlock.FACING)), entity.level(), pos)).getTravelPoints().size() < 3) {
            if (!isPlayer) {
                return;
            }
            MessageUtils.sendActionMessage((Player)player, (Component)Component.translatable((String)"hypertube.travel.too_short").withColor(0xFF0000), true);
            return;
        }
        entityPersistentData.putBoolean("hypertube_travel", true);
        float finalSpeed = speed * 1.0f;
        TravelPathMover pathMover = new TravelPathMover(entity.position(), travelPathData.getTravelPoints(), finalSpeed, travelPathData.getEndDirection(entity.level()), travelPathData.getLastBlockPos(), TravelManager::finishTravel);
        travelDataMap.put(entity.getUUID(), pathMover);
        MovePathPacket movePathPacket = new MovePathPacket(entity.getId(), travelPathData.getTravelPoints(), finalSpeed);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)movePathPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        Vec3 center = pos.getCenter();
        TubeSoundManager.playTubeSuctionSound(entity, center);
        TravelManager.syncPersistentData(entity);
        HypertubeMod.LOGGER.debug("Travel started: {} to {} and speed {}", (Object)entity.getName().getString(), (Object)relative, (Object)Float.valueOf(pathMover.getTravelSpeed()));
    }

    public static void entityTick(LivingEntity entity) {
        TravelManager.handleCommon(entity);
        if (entity.level().isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            TravelManager.clientTick(player);
            return;
        }
        if (entity.level().isClientSide) {
            return;
        }
        TravelManager.handleServer(entity);
    }

    private static void handleCommon(LivingEntity entity) {
        if (TravelManager.hasHyperTubeData((Entity)entity)) {
            entity.refreshDimensions();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientTick(Player player) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (!mc.player.is((Entity)player)) {
            return;
        }
        if (TravelManager.hasHyperTubeData((Entity)player)) {
            TubeSoundManager.TravelSound.enableClientPlayerSound((Entity)player, 0.8f, 1.0f);
            isTraveling = true;
            return;
        }
        if (isTraveling && !((Boolean)ClientConfig.get().ALLOW_FPV_INSIDE_TUBE.get()).booleanValue()) {
            Minecraft.getInstance().options.setCameraType(CameraType.FIRST_PERSON);
            isTraveling = false;
        }
    }

    public static void finishTravel(ServerPlayer player) {
        if (!travelDataMap.containsKey(player.getUUID())) {
            return;
        }
        TravelManager.finishTravel((LivingEntity)player, true);
    }

    private static void finishTravel(LivingEntity entity, boolean forced) {
        Level level = entity.level();
        if (level.isClientSide) {
            return;
        }
        TravelPathMover pathMover = travelDataMap.get(entity.getUUID());
        travelDataMap.remove(entity.getUUID());
        entity.getPersistentData().putBoolean("hypertube_travel", false);
        entity.getPersistentData().putLong("last_travel_time", System.currentTimeMillis() + 2000L);
        entity.getPersistentData().putLong("last_travel_blockpos", pathMover.getLastPos().asLong());
        float finalSpeed = pathMover.getTravelSpeed();
        entity.getPersistentData().putFloat("last_travel_speed", finalSpeed);
        entity.getPersistentData().putBoolean("hypertube_immunity", true);
        TravelManager.syncPersistentData(entity);
        Vec3 lastDir = pathMover.getLastDir();
        Vec3 lastBlockPos = pathMover.getLastPos().getCenter();
        BlockState blockState = level.getBlockState(BlockPos.containing((Position)lastBlockPos));
        if (blockState.getBlock() instanceof HyperEntranceBlock) {
            lastBlockPos = pathMover.getLastPos().relative(((Direction)blockState.getValue((Property)HyperEntranceBlock.FACING)).getOpposite()).getCenter();
        }
        if (!forced) {
            if (level instanceof ServerLevel) {
                entity.teleportTo((ServerLevel)level, lastBlockPos.x, lastBlockPos.y, lastBlockPos.z, RelativeMovement.ALL, entity.getYRot(), entity.getXRot());
            }
            entity.setDeltaMovement(lastDir.scale((double)Math.max(finalSpeed, 1.0f)));
        }
        entity.hurtMarked = true;
        entity.setPose(Pose.SWIMMING);
        TubeSoundManager.playTubeSuctionSound(entity, entity.position());
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        player.startFallFlying();
    }

    public static void finishTravel(UUID entityUuid) {
        TravelPathMover pathMover = travelDataMap.get(entityUuid);
        if (pathMover == null) {
            return;
        }
        pathMover.setClientFinish();
    }

    private static void handleServer(LivingEntity entity) {
        if (!travelDataMap.containsKey(entity.getUUID())) {
            if (!entity.getPersistentData().getBoolean("hypertube_travel")) {
                return;
            }
            entity.getPersistentData().putBoolean("hypertube_travel", false);
            return;
        }
        TravelPathMover travelPathData = travelDataMap.get(entity.getUUID());
        entity.resetFallDistance();
        travelPathData.tickEntity(entity);
    }

    public static boolean hasHyperTubeData(Entity entity) {
        return entity.getPersistentData().getBoolean("hypertube_travel");
    }

    private static void syncPersistentData(LivingEntity entity) {
        PlayerSyncEvents.syncPlayerStateToAll(entity, true);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SyncPersistentDataPacket.create((Entity)entity), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

