/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.travel;

import com.pedrorok.hypertube.core.camera.DetachedPlayerDirController;
import com.pedrorok.hypertube.network.packets.FinishPathPacket;
import com.pedrorok.hypertube.network.packets.MovePathPacket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientTravelPathMover {
    private static final Map<Integer, PathData> ACTIVE_PATHS = new HashMap<Integer, PathData>();

    public static void startMoving(MovePathPacket packet) {
        boolean isPlayer = Minecraft.getInstance().player.getId() == packet.entityId();
        ACTIVE_PATHS.put(packet.entityId(), new PathData(packet.pathPoints(), packet.travelSpeed(), isPlayer));
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            return;
        }
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        Iterator<Map.Entry<Integer, PathData>> it = ACTIVE_PATHS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, PathData> entry = it.next();
            int id = entry.getKey();
            PathData data = entry.getValue();
            Entity entity = level.getEntity(id);
            if (entity == null || !entity.isAlive() || entity.isSpectator()) {
                it.remove();
                continue;
            }
            if (data.isDone()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FinishPathPacket(entity.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                it.remove();
                continue;
            }
            data.updateLogicalPosition();
            entity.setDeltaMovement(data.getCurrentDirection());
            if (!data.isClientPlayer()) continue;
            ClientTravelPathMover.handleEntityDirection(data.getCurrentDirection());
        }
    }

    @SubscribeEvent
    public static void onRenderTick(RenderFrameEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        for (Map.Entry<Integer, PathData> entry : ACTIVE_PATHS.entrySet()) {
            int id = entry.getKey();
            PathData data = entry.getValue();
            Entity entity = level.getEntity(id);
            if (entity == null || !entity.isAlive() || entity.isSpectator()) continue;
            Vec3 renderPos = data.getRenderPosition(partialTicks);
            entity.moveTo(renderPos.x, renderPos.y, renderPos.z);
        }
    }

    private static void handleEntityDirection(Vec3 direction) {
        float yaw = (float)Math.toDegrees(Math.atan2(-direction.x, direction.z));
        float pitch = (float)Math.toDegrees(Math.atan2(-direction.y, Math.sqrt(direction.x * direction.x + direction.z * direction.z)));
        DetachedPlayerDirController.get().setDetached(true);
        DetachedPlayerDirController.get().updateRotation(yaw, pitch);
    }

    public static void updateSegment(int entityId, int segment) {
        PathData data = ACTIVE_PATHS.get(entityId);
        if (data != null) {
            if (data.lastUpdateTick > 0) {
                --data.lastUpdateTick;
                return;
            }
            data.lastUpdateTick = 5;
            data.currentIndex = segment;
            data.updateLogicalPosition();
        }
    }

    private static class PathData {
        private final List<Vec3> points;
        private final double travelSpeed;
        private int currentIndex = 0;
        private int lastUpdateTick = 0;
        private Vec3 currentLogicalPos;
        private Vec3 previousLogicalPos;
        private boolean clientPlayer;

        public PathData(List<Vec3> points, double blocksPerSecond, boolean clientPlayer) {
            this.points = points;
            this.travelSpeed = blocksPerSecond;
            this.clientPlayer = clientPlayer;
            if (!points.isEmpty()) {
                this.previousLogicalPos = this.currentLogicalPos = points.get(0).subtract(0.0, 0.25, 0.0);
            }
        }

        public boolean isDone() {
            return this.currentIndex >= this.points.size();
        }

        public Vec3 getCurrentTarget() {
            if (this.currentIndex < this.points.size()) {
                return this.points.get(this.currentIndex).subtract(0.0, 0.25, 0.0);
            }
            return this.currentLogicalPos;
        }

        public void updateLogicalPosition() {
            if (this.isDone()) {
                return;
            }
            Vec3 target = this.getCurrentTarget();
            double distanceToTarget = this.currentLogicalPos.distanceTo(target);
            boolean doHalfStep = true;
            this.previousLogicalPos = this.currentLogicalPos;
            if (distanceToTarget < this.travelSpeed) {
                this.currentLogicalPos = target;
                this.currentIndex = (int)((double)this.currentIndex + Math.max(1.0, this.travelSpeed));
                if (this.travelSpeed <= 1.0) {
                    doHalfStep = false;
                }
            }
            if (doHalfStep) {
                Vec3 direction = target.subtract(this.currentLogicalPos).normalize().scale(this.travelSpeed);
                this.currentLogicalPos = this.currentLogicalPos.add(direction);
            }
        }

        public Vec3 getCurrentDirection() {
            if (this.currentLogicalPos.equals((Object)this.previousLogicalPos)) {
                return Vec3.ZERO;
            }
            return this.currentLogicalPos.subtract(this.previousLogicalPos).normalize();
        }

        public Vec3 getRenderPosition(float partialTicks) {
            return this.previousLogicalPos.lerp(this.currentLogicalPos, (double)partialTicks);
        }

        public boolean isClientPlayer() {
            return this.clientPlayer;
        }
    }
}

