/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pedrorok.hypertube.blocks.HyperEntranceBlock;
import com.pedrorok.hypertube.blocks.blockentities.HyperEntranceBlockEntity;
import com.pedrorok.hypertube.client.BezierTextureRenderer;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.registry.ModPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntranceBlockEntityRenderer
extends KineticBlockEntityRenderer<HyperEntranceBlockEntity> {
    private final BezierTextureRenderer tubeRenderer = BezierTextureRenderer.get();

    public EntranceBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(HyperEntranceBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.getBlockState();
        if (!(blockState.getBlock() instanceof HyperEntranceBlock)) {
            return;
        }
        Direction facing = (Direction)blockState.getValue((Property)HyperEntranceBlock.FACING);
        SuperByteBuffer cogwheelModel = CachedBuffers.partialFacingVertical((PartialModel)ModPartialModels.COGWHEEL_HOLE, (BlockState)blockState, (Direction)facing);
        float angle = EntranceBlockEntityRenderer.getAngleForBe((KineticBlockEntity)be, (BlockPos)be.getBlockPos(), (Direction.Axis)facing.getAxis());
        Direction.Axis rotationAxisOf = EntranceBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be);
        EntranceBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)cogwheelModel, (KineticBlockEntity)be, (Direction.Axis)rotationAxisOf, (float)angle, (int)light);
        cogwheelModel.renderInto(ms, buffer.getBuffer(RenderType.solid()));
        IConnection iConnection = be.getConnection();
        if (iConnection instanceof BezierConnection) {
            BezierConnection bezierConnection = (BezierConnection)iConnection;
            this.tubeRenderer.renderBezierConnection(be.getBlockPos(), bezierConnection, ms, buffer, light, overlay);
        }
    }

    public boolean shouldRenderOffScreen(HyperEntranceBlockEntity p_112306_) {
        return true;
    }

    public boolean shouldRender(HyperEntranceBlockEntity p_173568_, Vec3 p_173569_) {
        return true;
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull HyperEntranceBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

