/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pedrorok.hypertube.client.TubeRing;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class BezierTextureRenderer {
    private static BezierTextureRenderer INSTANCE;
    private static final float TUBE_RADIUS = 0.7f;
    private static final float INNER_TUBE_RADIUS = 0.62f;
    private static final float LINE_RADIUS = 0.69f;
    private static final int SEGMENTS_AROUND = 4;
    private static final float TILING_UNIT = 1.0f;
    private static final float UP_ALIGNMENT_THRESHOLD = 0.999f;
    private final ResourceLocation textureTube = ResourceLocation.fromNamespaceAndPath((String)"create_hypertube", (String)"textures/block/tube_base_glass.png");
    private final ResourceLocation textureLine = ResourceLocation.fromNamespaceAndPath((String)"create_hypertube", (String)"textures/block/tube_base_glass_2.png");

    public void renderBezierConnection(BlockPos blockPosInitial, BezierConnection connection, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (connection == null || !connection.getValidation().valid()) {
            return;
        }
        List<Vec3> bezierPoints = connection.getBezierPoints();
        if (bezierPoints.size() < 2) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        BlockEntity blockEntity = level.getBlockEntity(blockPosInitial);
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            return;
        }
        int segmentDistance = connection.getTubeSegments();
        poseStack.pushPose();
        Vec3 blockPos = Vec3.atLowerCornerOf((Vec3i)blockPosInitial);
        poseStack.translate(-blockPos.x, -blockPos.y, -blockPos.z);
        Matrix4f pose = poseStack.last().pose();
        List<TubeRing> tubeGeometry = this.calculateAndCacheGeometry(bezierPoints);
        VertexConsumer builderExterior = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)this.textureTube));
        this.renderComponent(builderExterior, pose, packedLight, packedOverlay, tubeGeometry, SectionType.EXTERIOR, segmentDistance);
        VertexConsumer builderInterior = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.textureTube));
        this.renderComponent(builderInterior, pose, packedLight, packedOverlay, tubeGeometry, SectionType.INTERIOR, segmentDistance);
        VertexConsumer builderLine = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)this.textureLine));
        this.renderComponent(builderLine, pose, packedLight, packedOverlay, tubeGeometry, SectionType.LINE, segmentDistance);
        poseStack.popPose();
    }

    private void renderComponent(VertexConsumer builder, Matrix4f pose, int packedLight, int packedOverlay, List<TubeRing> tubeGeometry, SectionType sectionType, int segmentDistance) {
        if (tubeGeometry.size() < 2) {
            return;
        }
        boolean interiorTube = sectionType.equals((Object)SectionType.INTERIOR);
        boolean exteriorTube = sectionType.equals((Object)SectionType.EXTERIOR);
        boolean skipLine = sectionType.equals((Object)SectionType.EXTERIOR) || interiorTube;
        boolean doubleSided = sectionType.equals((Object)SectionType.LINE) || exteriorTube;
        for (int i = 0; i < tubeGeometry.size() - 1; ++i) {
            List<Vector3f> currentOffsets;
            if (skipLine && (i % segmentDistance != 0 || segmentDistance > 1 && (i > tubeGeometry.size() - 3 || i == 0))) continue;
            TubeRing current = tubeGeometry.get(i);
            TubeRing next = tubeGeometry.get(i + 1);
            Vec3 dirVec = next.center().subtract(current.center());
            float segmentLength = (float)dirVec.length();
            if ((double)segmentLength < 1.0E-6) continue;
            Vector3f tangent = new Vector3f((float)dirVec.x, (float)dirVec.y, (float)dirVec.z).normalize();
            List<Vector3f> list = interiorTube ? current.interiorOffsets() : (currentOffsets = exteriorTube ? current.exteriorOffsets() : current.lineOffsets());
            List<Vector3f> nextOffsets = interiorTube ? next.interiorOffsets() : (exteriorTube ? next.exteriorOffsets() : next.lineOffsets());
            for (int j = 0; j < 4; ++j) {
                int nextJ = (j + 1) % 4;
                float uStart = current.uCoordinate();
                Vector3f corner_j_movement = new Vector3f((float)(next.center().x + (double)nextOffsets.get((int)j).x) - (float)(current.center().x + (double)currentOffsets.get((int)j).x), (float)(next.center().y + (double)nextOffsets.get((int)j).y) - (float)(current.center().y + (double)currentOffsets.get((int)j).y), (float)(next.center().z + (double)nextOffsets.get((int)j).z) - (float)(current.center().z + (double)currentOffsets.get((int)j).z));
                float uEnd_j = uStart + corner_j_movement.dot((Vector3fc)tangent) / 1.0f;
                Vector3f corner_nextJ_movement = new Vector3f((float)(next.center().x + (double)nextOffsets.get((int)nextJ).x) - (float)(current.center().x + (double)currentOffsets.get((int)nextJ).x), (float)(next.center().y + (double)nextOffsets.get((int)nextJ).y) - (float)(current.center().y + (double)currentOffsets.get((int)nextJ).y), (float)(next.center().z + (double)nextOffsets.get((int)nextJ).z) - (float)(current.center().z + (double)currentOffsets.get((int)nextJ).z));
                float uEnd_nextJ = uStart + corner_nextJ_movement.dot((Vector3fc)tangent) / 1.0f;
                float vStart = 0.0f;
                float vEnd = 1.0f;
                if (doubleSided) {
                    this.addVertex(builder, pose, current.center(), currentOffsets.get(nextJ), uStart, vEnd, packedLight, packedOverlay, false);
                    this.addVertex(builder, pose, next.center(), nextOffsets.get(nextJ), uEnd_nextJ, vEnd, packedLight, packedOverlay, false);
                    this.addVertex(builder, pose, next.center(), nextOffsets.get(j), uEnd_j, vStart, packedLight, packedOverlay, false);
                    this.addVertex(builder, pose, current.center(), currentOffsets.get(j), uStart, vStart, packedLight, packedOverlay, false);
                }
                if (interiorTube) {
                    this.addVertex(builder, pose, current.center(), currentOffsets.get(nextJ), uStart, vEnd, packedLight, packedOverlay, true);
                    this.addVertex(builder, pose, next.center(), nextOffsets.get(nextJ), uEnd_nextJ, vEnd, packedLight, packedOverlay, true);
                    this.addVertex(builder, pose, next.center(), nextOffsets.get(j), uEnd_j, vStart, packedLight, packedOverlay, true);
                    this.addVertex(builder, pose, current.center(), currentOffsets.get(j), uStart, vStart, packedLight, packedOverlay, true);
                    continue;
                }
                this.addVertex(builder, pose, current.center(), currentOffsets.get(j), uStart, vStart, packedLight, packedOverlay, doubleSided);
                this.addVertex(builder, pose, next.center(), nextOffsets.get(j), uEnd_j, vStart, packedLight, packedOverlay, doubleSided);
                this.addVertex(builder, pose, next.center(), nextOffsets.get(nextJ), uEnd_nextJ, vEnd, packedLight, packedOverlay, doubleSided);
                this.addVertex(builder, pose, current.center(), currentOffsets.get(nextJ), uStart, vEnd, packedLight, packedOverlay, doubleSided);
            }
        }
    }

    private List<TubeRing> calculateAndCacheGeometry(List<Vec3> points) {
        ArrayList<TubeRing> cachedGeometry = new ArrayList<TubeRing>();
        Vector3f upVector = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f lastPerpA = null;
        Vector3f lastPerpB = null;
        for (int i = 0; i < points.size(); ++i) {
            Vec3 currentPoint = points.get(i);
            Vector3f tangent = BezierTextureRenderer.getTangent(points, i, currentPoint);
            Vector3f[] perpendiculars = this.computeStablePerpendiculars(tangent, upVector, lastPerpA, lastPerpB);
            Vector3f perpA = perpendiculars[0];
            Vector3f perpB = perpendiculars[1];
            lastPerpA = new Vector3f((Vector3fc)perpA);
            lastPerpB = new Vector3f((Vector3fc)perpB);
            List<Vector3f> ringExterior = this.generateRingOffsets(perpA, perpB, 0.7f);
            List<Vector3f> ringInterior = this.generateRingOffsets(perpA, perpB, 0.62f);
            List<Vector3f> ringLine = this.generateRingOffsets(perpA, perpB, 0.69f);
            cachedGeometry.add(new TubeRing(currentPoint, ringExterior, ringInterior, ringLine, 0.8f));
        }
        return cachedGeometry;
    }

    @NotNull
    private static Vector3f getTangent(List<Vec3> points, int i, Vec3 currentPoint) {
        Vector3f tangent = i == points.size() - 1 ? new Vector3f((float)(currentPoint.x - points.get((int)(i - 1)).x), (float)(currentPoint.y - points.get((int)(i - 1)).y), (float)(currentPoint.z - points.get((int)(i - 1)).z)) : new Vector3f((float)(points.get((int)(i + 1)).x - currentPoint.x), (float)(points.get((int)(i + 1)).y - currentPoint.y), (float)(points.get((int)(i + 1)).z - currentPoint.z));
        tangent.normalize();
        return tangent;
    }

    private Vector3f[] computeStablePerpendiculars(Vector3f tangent, Vector3f upVector, Vector3f lastPerpA, Vector3f lastPerpB) {
        Vector3f perpA = new Vector3f();
        Vector3f perpB = new Vector3f();
        float upAlignment = Math.abs(tangent.dot((Vector3fc)upVector));
        if (upAlignment > 0.999f) {
            if (lastPerpA != null && lastPerpB != null) {
                perpA.set((Vector3fc)lastPerpA);
                perpB.set((Vector3fc)lastPerpB);
                float dotA = Math.abs(tangent.dot((Vector3fc)perpA));
                float dotB = Math.abs(tangent.dot((Vector3fc)perpB));
                if (dotA > 0.1f || dotB > 0.1f) {
                    this.getTanCross(tangent, perpA, perpB);
                }
            } else {
                this.getTanCross(tangent, perpA, perpB);
            }
        } else {
            float dotWithLast;
            Vector3f projectedUp = new Vector3f((Vector3fc)upVector);
            float dotProduct = tangent.dot((Vector3fc)upVector);
            Vector3f tangentComponent = new Vector3f((Vector3fc)tangent).mul(dotProduct);
            projectedUp.sub((Vector3fc)tangentComponent);
            projectedUp.normalize();
            Vector3f candidatePerpA = new Vector3f((Vector3fc)projectedUp);
            if (lastPerpA != null && (dotWithLast = candidatePerpA.dot((Vector3fc)lastPerpA)) < 0.0f) {
                candidatePerpA.negate();
            }
            perpA.set((Vector3fc)candidatePerpA);
            tangent.cross((Vector3fc)perpA, perpB);
            perpB.normalize();
        }
        return new Vector3f[]{perpA, perpB};
    }

    private void getTanCross(Vector3f tangent, Vector3f perpA, Vector3f perpB) {
        float zDot;
        Vector3f xAxis = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f zAxis = new Vector3f(0.0f, 0.0f, 1.0f);
        float xDot = Math.abs(tangent.dot((Vector3fc)xAxis));
        Vector3f chosenAxis = xDot < (zDot = Math.abs(tangent.dot((Vector3fc)zAxis))) ? xAxis : zAxis;
        tangent.cross((Vector3fc)chosenAxis, perpA);
        perpA.normalize();
        tangent.cross((Vector3fc)perpA, perpB);
        perpB.normalize();
    }

    private void addVertex(VertexConsumer builder, Matrix4f pose, Vec3 pos, Vector3f offset, float u, float v, int light, int overlay, boolean invertNormal) {
        float x = (float)pos.x + offset.x;
        float y = (float)pos.y + offset.y;
        float z = (float)pos.z + offset.z;
        float normalMultiplier = invertNormal ? -1.0f : 1.0f;
        float nx = offset.x * normalMultiplier;
        float ny = offset.y * normalMultiplier;
        float nz = offset.z * normalMultiplier;
        builder.addVertex(pose, x, y, z).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(overlay).setUv2(light & 0xFFFF, light >> 16).setNormal(nx, ny, nz);
    }

    private List<Vector3f> generateRingOffsets(Vector3f perpA, Vector3f perpB, float radius) {
        ArrayList<Vector3f> ring = new ArrayList<Vector3f>();
        for (int j = 0; j < 4; ++j) {
            float angle = (float)((double)(j * 2) * Math.PI / 4.0) + 0.7853982f;
            ring.add(this.getOffset(perpA, perpB, angle, radius));
        }
        return ring;
    }

    private Vector3f getOffset(Vector3f perpA, Vector3f perpB, float angle, float radius) {
        float cosAngle = Mth.cos((float)angle);
        float sinAngle = Mth.sin((float)angle);
        return new Vector3f((cosAngle * perpA.x + sinAngle * perpB.x) * radius, (cosAngle * perpA.y + sinAngle * perpB.y) * radius, (cosAngle * perpA.z + sinAngle * perpB.z) * radius);
    }

    public static BezierTextureRenderer get() {
        if (INSTANCE == null) {
            INSTANCE = new BezierTextureRenderer();
        }
        return INSTANCE;
    }

    private static enum SectionType {
        EXTERIOR,
        INTERIOR,
        LINE;

    }
}

