/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.blocks.HypertubeBlock;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.TubeConnectionException;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HypertubeBlockEntity
extends BlockEntity
implements ITubeConnectionEntity {
    private IConnection connectionOne;
    private IConnection connectionTwo;

    public HypertubeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.writeConnection(tag, new Tuple[]{new Tuple((Object)this.connectionOne, (Object)"ConnectionTo"), new Tuple((Object)this.connectionTwo, (Object)"ConnectionFrom")});
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("ConnectionTo")) {
            this.connectionOne = this.getConnection(tag, "ConnectionTo");
        }
        if (tag.contains("ConnectionFrom")) {
            this.connectionTwo = this.getConnection(tag, "ConnectionFrom");
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    @NotNull
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(@NotNull Connection net, ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.loadAdditional(tag, registries);
    }

    @Override
    public boolean wrenchClicked(Direction direction) {
        IConnection connectionInDirection = this.getConnectionInDirection(direction);
        if (connectionInDirection == null) {
            if (this.connectionOne != null) {
                this.connectionOne.updateTubeSegments(this.level);
            }
            if (this.connectionTwo != null) {
                this.connectionTwo.updateTubeSegments(this.level);
            }
            return true;
        }
        connectionInDirection.updateTubeSegments(this.level);
        return true;
    }

    @Override
    public List<Direction> getFacesConnectable() {
        if (this.connectionOne != null && this.connectionTwo != null) {
            return List.of();
        }
        List<Direction> possibleDirections = ((HypertubeBlock)this.getBlockState().getBlock()).getConnectedFaces(this.getBlockState());
        if (possibleDirections.isEmpty()) {
            return List.of(Direction.values());
        }
        possibleDirections.removeIf(direction -> {
            if (this.connectionOne != null) {
                return this.getConnectionDirection((Direction)direction, this.connectionOne);
            }
            if (this.connectionTwo != null) {
                return this.getConnectionDirection((Direction)direction, this.connectionTwo);
            }
            return false;
        });
        return possibleDirections;
    }

    @Override
    public List<IConnection> getConnections() {
        ArrayList<IConnection> connections = new ArrayList<IConnection>();
        if (this.connectionOne != null) {
            connections.add(this.connectionOne);
        }
        if (this.connectionTwo != null) {
            connections.add(this.connectionTwo);
        }
        return connections;
    }

    @Override
    @Nullable
    public IConnection getConnectionInDirection(Direction direction) {
        if (this.getConnectionDirection(direction, this.connectionOne)) {
            return this.connectionOne;
        }
        if (this.getConnectionDirection(direction, this.connectionTwo)) {
            return this.connectionTwo;
        }
        return null;
    }

    private boolean getConnectionDirection(Direction direction, IConnection connection) {
        SimpleConnection sameConnectionBlockPos;
        if (connection != null && (sameConnectionBlockPos = IConnection.getSameConnectionBlockPos(connection, this.level, this.worldPosition)) != null) {
            Direction thisConn = sameConnectionBlockPos.direction();
            return thisConn != null && thisConn.equals((Object)direction);
        }
        return false;
    }

    @Override
    @Nullable
    public IConnection getThisConnectionFrom(SimpleConnection connection) {
        BezierConnection bezierConnection;
        IConnection iConnection = this.connectionOne;
        if (iConnection instanceof BezierConnection && connection.isSameConnection((bezierConnection = (BezierConnection)iConnection).getFromPos())) {
            return bezierConnection;
        }
        iConnection = this.connectionTwo;
        if (iConnection instanceof BezierConnection && connection.isSameConnection((bezierConnection = (BezierConnection)iConnection).getFromPos())) {
            return bezierConnection;
        }
        return null;
    }

    @Override
    public boolean hasConnectionAvailable() {
        return this.connectionTwo == null || this.connectionOne == null;
    }

    @Override
    public boolean isConnected() {
        return this.connectionOne != null || this.connectionTwo != null;
    }

    @Override
    public void setConnection(IConnection connection, Direction thisConnectionDir) {
        BlockState blockState;
        Block block;
        if (this.connectionOne == null) {
            this.connectionOne = connection;
        } else if (this.connectionTwo == null) {
            this.connectionTwo = connection;
        } else {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not define connection", connection, this.connectionOne, this.connectionTwo).getMessage());
            return;
        }
        if (this.level != null && !this.level.isClientSide() && (block = (blockState = this.level.getBlockState(this.worldPosition)).getBlock()) instanceof HypertubeBlock) {
            HypertubeBlock hypertubeBlock = (HypertubeBlock)block;
            hypertubeBlock.updateBlockStateFromEntity(blockState, this.level, this.worldPosition);
            if (thisConnectionDir != null) {
                BlockState state = hypertubeBlock.getState(blockState, List.of(thisConnectionDir), true);
                hypertubeBlock.updateBlockState(this.level, this.worldPosition, state);
            }
        }
        this.setChanged();
        this.sync();
    }

    @Override
    public void clearConnection(IConnection connection) {
        BlockState blockState;
        Block block;
        if (this.connectionOne != null && this.connectionOne.isSameConnection(connection)) {
            this.connectionOne = null;
        } else if (this.connectionTwo != null && this.connectionTwo.isSameConnection(connection)) {
            this.connectionTwo = null;
        } else {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not be cleared", connection, this.connectionOne, this.connectionTwo).getMessage());
            return;
        }
        if (this.level != null && !this.level.isClientSide() && (block = (blockState = this.level.getBlockState(this.worldPosition)).getBlock()) instanceof HypertubeBlock) {
            HypertubeBlock hypertubeBlock = (HypertubeBlock)block;
            hypertubeBlock.updateBlockStateFromEntity(blockState, this.level, this.worldPosition);
        }
        this.setChanged();
        this.sync();
    }

    @Override
    public int blockBroken() {
        int toDrop = 0;
        if (this.connectionOne != null) {
            toDrop = this.blockBroken(this.level, this.connectionOne, this.worldPosition);
        }
        if (this.connectionTwo != null) {
            toDrop += this.blockBroken(this.level, this.connectionTwo, this.worldPosition);
        }
        return toDrop;
    }

    @Override
    public Vec3 getExitDirection() {
        if (this.connectionOne != null && this.connectionTwo != null) {
            return null;
        }
        if (this.connectionTwo != null) {
            return Vec3.atLowerCornerOf((Vec3i)IConnection.getSameConnectionBlockPos(this.connectionTwo, this.level, this.getBlockPos()).direction().getOpposite().getNormal());
        }
        if (this.connectionOne != null) {
            return Vec3.atLowerCornerOf((Vec3i)IConnection.getSameConnectionBlockPos(this.connectionOne, this.level, this.getBlockPos()).direction().getOpposite().getNormal());
        }
        return null;
    }

    public void sync() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public IConnection getConnectionOne() {
        return this.connectionOne;
    }

    public IConnection getConnectionTwo() {
        return this.connectionTwo;
    }
}

