/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.blocks.HyperEntranceBlock;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.TubeConnectionException;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.pedrorok.hypertube.core.travel.TravelConstants;
import com.pedrorok.hypertube.core.travel.TravelManager;
import com.pedrorok.hypertube.registry.ModParticles;
import com.pedrorok.hypertube.registry.ModSounds;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class HyperEntranceBlockEntity
extends KineticBlockEntity
implements IHaveHoveringInformation,
ITubeConnectionEntity {
    private static final float RADIUS = 1.0f;
    private static final float SPEED_TO_START = 16.0f;
    private final UUID tubeSoundId = UUID.randomUUID();
    private IConnection connection;

    public HyperEntranceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (compound.contains("Connection")) {
            this.connection = this.getConnection(compound, "Connection");
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        this.writeConnection(compound, new Tuple[]{new Tuple((Object)this.connection, (Object)"Connection")});
    }

    @Override
    public boolean wrenchClicked(Direction direction) {
        IConnection connectionInDirection = this.getConnectionInDirection(direction);
        if (connectionInDirection == null) {
            return false;
        }
        connectionInDirection.updateTubeSegments(this.level);
        return true;
    }

    public void remove() {
        if (this.level.isClientSide) {
            this.removeClient();
        }
        super.remove();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void removeClient() {
        TubeSoundManager.getAmbientSound(this.tubeSoundId).stopSound();
        TubeSoundManager.removeAmbientSound(this.tubeSoundId);
    }

    public void tick() {
        LivingEntity inRangeEntity;
        boolean canOpen;
        super.tick();
        Boolean isBlocked = (Boolean)this.getBlockState().getValue((Property)HyperEntranceBlock.IN_FRONT);
        if (this.level.isClientSide) {
            this.tickClient(isBlocked);
            return;
        }
        if (isBlocked.booleanValue()) {
            return;
        }
        BlockState state = this.getBlockState();
        BlockPos pos = this.getBlockPos();
        float actualSpeed = Math.abs(this.getSpeed());
        Boolean isOpen = (Boolean)state.getValue((Property)HyperEntranceBlock.OPEN);
        if (actualSpeed < 16.0f) {
            if (isOpen.booleanValue()) {
                this.level.setBlock(pos, (BlockState)state.setValue((Property)HyperEntranceBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
                this.playOpenCloseSound(false);
            }
            return;
        }
        boolean isLocked = (Boolean)this.getBlockState().getValue((Property)HyperEntranceBlock.LOCKED) == false;
        LivingEntity nearbyEntity = this.getNearbyLivingEntities((ServerLevel)this.level, pos.getCenter());
        boolean bl = canOpen = nearbyEntity != null && (isLocked || nearbyEntity.isShiftKeyDown() || nearbyEntity.getPersistentData().getBoolean("hypertube_travel"));
        if (!canOpen) {
            if (isOpen.booleanValue()) {
                this.level.setBlock(pos, (BlockState)state.setValue((Property)HyperEntranceBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
                this.playOpenCloseSound(false);
            }
            return;
        }
        if (!isOpen.booleanValue()) {
            this.level.setBlock(pos, (BlockState)state.setValue((Property)HyperEntranceBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
            this.playOpenCloseSound(true);
        }
        if ((inRangeEntity = this.getInRangeLivingEntities((ServerLevel)this.level, pos.getCenter(), (Direction)state.getValue((Property)HyperEntranceBlock.FACING))) == null) {
            return;
        }
        if (!(isLocked || inRangeEntity.isShiftKeyDown() || inRangeEntity.getPersistentData().getBoolean("hypertube_travel"))) {
            return;
        }
        TravelManager.tryStartTravel(inRangeEntity, pos, state, 0.4333f + actualSpeed / 240.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient(boolean isBlocked) {
        BlockState state = this.getBlockState();
        BlockPos pos = this.getBlockPos();
        float actualSpeed = Math.abs(this.getSpeed());
        TubeSoundManager.TubeAmbientSound sound = TubeSoundManager.getAmbientSound(this.tubeSoundId);
        if (actualSpeed < 16.0f || isBlocked) {
            sound.tickClientPlayerSounds();
            return;
        }
        boolean isOpen = (Boolean)state.getValue((Property)HyperEntranceBlock.OPEN);
        LocalPlayer player = Minecraft.getInstance().player;
        Vec3 source = pos.getCenter();
        Vec3 listener = player.position();
        Vec3 worldDirection = source.subtract(listener).normalize();
        Vec3 forward = player.getLookAngle().normalize();
        Vec3 up = player.getUpVector(1.0f).normalize();
        Vec3 right = forward.cross(up).normalize();
        double x = worldDirection.dot(right);
        double y = worldDirection.dot(up);
        double z = worldDirection.dot(forward);
        Vec3 rotatedDirection = new Vec3(x, y, z).normalize();
        double distance = player.distanceToSqr(source);
        if (isOpen) {
            HyperEntranceBlockEntity.spawnSuctionParticle(this.level, pos, (Direction)state.getValue((Property)HyperEntranceBlock.FACING));
        }
        sound.enableClientPlayerSound((Entity)player, rotatedDirection, distance, isOpen);
    }

    @Nullable
    private LivingEntity getInRangeLivingEntities(ServerLevel level, Vec3 centerPos, Direction facing) {
        Vec3 checkPos = centerPos.add(Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()));
        return level.getNearestEntity(level.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)checkPos, (double)1.5, (double)1.5, (double)1.5), entity -> TravelConstants.TRAVELLER_ENTITIES.contains(entity.getType())), TargetingConditions.forNonCombat().ignoreLineOfSight(), null, centerPos.x, centerPos.y, centerPos.z);
    }

    @Nullable
    private LivingEntity getNearbyLivingEntities(ServerLevel level, Vec3 centerPos) {
        return level.getNearestEntity(level.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)centerPos, (double)6.0, (double)6.0, (double)6.0), entity -> TravelConstants.TRAVELLER_ENTITIES.contains(entity.getType())), TargetingConditions.forNonCombat().ignoreLineOfSight(), null, centerPos.x, centerPos.y, centerPos.z);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float finalSpeed = Math.abs(this.getSpeed());
        IRotate.SpeedLevel.getFormattedSpeedText((float)this.speed, (finalSpeed < 16.0f ? 1 : 0) != 0).forGoggles(tooltip);
        if (((Boolean)this.getBlockState().getValue((Property)HyperEntranceBlock.IN_FRONT)).booleanValue()) {
            tooltip.add((Component)Component.literal((String)"     ").append((Component)Component.translatable((String)"tooltip.create_hypertube.entrance_blocked").withColor(0xFF0000)));
        } else if (finalSpeed < 16.0f) {
            tooltip.add((Component)Component.literal((String)"     ").append((Component)Component.literal((String)"\u2592 ")).append((Component)Component.translatable((String)"tooltip.create_hypertube.entrance_no_speed")).withColor(0xFF0000));
        }
        return true;
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (((Boolean)this.getBlockState().getValue((Property)HyperEntranceBlock.LOCKED)).booleanValue() && Math.abs(this.getSpeed()) >= 16.0f) {
            tooltip.add((Component)Component.literal((String)"     ").append((Component)Component.translatable((String)"block.hypertube.hyper_entrance.sneak_to_enter")).withColor(0xFFFFFF));
        }
        return true;
    }

    private void playOpenCloseSound(boolean open) {
        RandomSource random = this.level.random;
        float pitch = 0.4f + random.nextFloat() * 0.4f;
        this.level.playSound(null, this.getBlockPos(), open ? (SoundEvent)ModSounds.HYPERTUBE_ENTRANCE_OPEN.get() : (SoundEvent)ModSounds.HYPERTUBE_ENTRANCE_CLOSE.get(), SoundSource.BLOCKS, 0.2f, pitch);
    }

    @Override
    @Nullable
    public IConnection getConnectionInDirection(Direction direction) {
        Direction thisConn;
        SimpleConnection sameConnectionBlockPos = IConnection.getSameConnectionBlockPos(this.connection, this.level, this.worldPosition);
        if (sameConnectionBlockPos != null && (thisConn = sameConnectionBlockPos.direction()) != null && thisConn.equals((Object)direction)) {
            return this.connection;
        }
        return null;
    }

    @Override
    @Nullable
    public IConnection getThisConnectionFrom(SimpleConnection connection) {
        BezierConnection bezierConnection;
        IConnection iConnection = this.connection;
        if (iConnection instanceof BezierConnection && connection.isSameConnection((bezierConnection = (BezierConnection)iConnection).getFromPos())) {
            return bezierConnection;
        }
        return null;
    }

    @Override
    public boolean hasConnectionAvailable() {
        return this.connection == null;
    }

    @Override
    public boolean isConnected() {
        return this.connection != null;
    }

    @Override
    public void setConnection(IConnection connection, Direction thisConnectionDir) {
        if (this.connection != null) {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not define connection", this.connection, connection).getMessage());
            return;
        }
        this.connection = connection;
        this.setChanged();
        this.sync();
    }

    @Override
    public void clearConnection(IConnection connection) {
        if (this.connection == null || !this.connection.isSameConnection(connection)) {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not be cleared", this.connection, connection).getMessage());
            return;
        }
        this.connection = null;
        this.setChanged();
        this.sync();
    }

    @Override
    public int blockBroken() {
        int toDrop = 0;
        if (this.connection != null) {
            toDrop = this.blockBroken(this.level, this.connection, this.worldPosition);
        }
        return toDrop;
    }

    @Override
    public List<Direction> getFacesConnectable() {
        if (this.connection != null) {
            return List.of();
        }
        return List.of((Direction)this.getBlockState().getValue((Property)HyperEntranceBlock.FACING));
    }

    @Override
    public List<IConnection> getConnections() {
        ArrayList<IConnection> connections = new ArrayList<IConnection>();
        if (this.connection != null) {
            connections.add(this.connection);
        }
        return connections;
    }

    public void sync() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public static void spawnSuctionParticle(Level level, BlockPos blockPos, Direction face) {
        face = face.getOpposite();
        Vec3 center = Vec3.atCenterOf((Vec3i)blockPos);
        RandomSource rand = level.getRandom();
        Vec3 faceNormal = Vec3.atLowerCornerOf((Vec3i)face.getNormal());
        double spread = 0.5;
        Vec3 tangentA = switch (face.getAxis()) {
            case Direction.Axis.Y, Direction.Axis.Z -> new Vec3(1.0, 0.0, 0.0);
            default -> new Vec3(0.0, 1.0, 0.0);
        };
        Vec3 tangentB = faceNormal.cross(tangentA).normalize();
        double offsetA = (rand.nextDouble() - 0.5) * 2.0 * spread;
        double offsetB = (rand.nextDouble() - 0.5) * 2.0 * spread;
        Vec3 randomOffset = tangentA.scale(offsetA).add(tangentB.scale(offsetB));
        Vec3 start = center.add(faceNormal.scale((double)(1.0f + level.random.nextFloat()))).add(randomOffset);
        Vec3 motion = center.subtract(start).normalize().scale(0.05);
        level.addParticle((ParticleOptions)ModParticles.SUCTION_PARTICLE.get(), start.x, start.y, start.z, motion.x, motion.y, motion.z);
    }

    @Override
    public Vec3 getExitDirection() {
        if (this.getBlockState().hasProperty((Property)HyperEntranceBlock.FACING)) {
            Direction facing = ((Direction)this.getBlockState().getValue((Property)HyperEntranceBlock.FACING)).getOpposite();
            return Vec3.atLowerCornerOf((Vec3i)facing.getNormal());
        }
        return null;
    }

    public IConnection getConnection() {
        return this.connection;
    }
}

