/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks;

import com.pedrorok.hypertube.blocks.blockentities.HypertubeBlockEntity;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import com.pedrorok.hypertube.registry.ModBlockEntities;
import com.pedrorok.hypertube.registry.ModBlocks;
import com.pedrorok.hypertube.registry.ModDataComponent;
import com.pedrorok.hypertube.utils.MessageUtils;
import com.pedrorok.hypertube.utils.RayCastUtils;
import com.pedrorok.hypertube.utils.TubeUtils;
import com.pedrorok.hypertube.utils.VoxelUtils;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HypertubeBlock
extends WaterloggedTransparentBlock
implements ITubeConnection,
IBE<HypertubeBlockEntity>,
IWrenchable {
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");
    public static final BooleanProperty NORTH_SOUTH = BooleanProperty.create((String)"north_south");
    public static final BooleanProperty EAST_WEST = BooleanProperty.create((String)"east_west");
    public static final BooleanProperty UP_DOWN = BooleanProperty.create((String)"up_down");
    public static final VoxelShape SHAPE_NORTH_SOUTH = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)11.0);
    public static final VoxelShape SHAPE_EAST_WEST = Block.box((double)5.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_UP_DOWN = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);

    public HypertubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH_SOUTH, EAST_WEST, UP_DOWN, CONNECTED, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        for (Direction direction : Direction.values()) {
            ITubeConnectionEntity otherTube;
            BlockPos relative = context.getClickedPos().relative(direction);
            BlockEntity otherEntity = context.getLevel().getBlockEntity(relative);
            if (!(otherEntity instanceof ITubeConnectionEntity) || !(otherTube = (ITubeConnectionEntity)otherEntity).getFacesConnectable().contains(direction.getOpposite())) continue;
            return this.getState(state, List.of(direction), true);
        }
        if (context.getPlayer() == null) {
            return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST_WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP_DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false));
        }
        Player player = context.getPlayer();
        Direction direction = context.getPlayer().getDirection();
        if (player.getXRot() < -45.0f) {
            direction = Direction.UP;
        } else if (player.getXRot() > 45.0f) {
            direction = Direction.DOWN;
        }
        return this.getState(state, List.of(direction), false);
    }

    public VoxelShape getShape(BlockState state, @Nullable CollisionContext ctx) {
        EntityCollisionContext ecc;
        if (ctx instanceof EntityCollisionContext && (ecc = (EntityCollisionContext)ctx).getEntity() != null && ecc.getEntity().getPersistentData().getBoolean("hypertube_travel")) {
            return VoxelUtils.empty();
        }
        if (((Boolean)state.getValue((Property)EAST_WEST)).booleanValue()) {
            return SHAPE_EAST_WEST;
        }
        if (((Boolean)state.getValue((Property)UP_DOWN)).booleanValue()) {
            return SHAPE_UP_DOWN;
        }
        return SHAPE_NORTH_SOUTH;
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos pos1, boolean b) {
        super.neighborChanged(state, world, pos, block, pos1, b);
        BlockState newState = this.getStateFromBlockEntity(state, world, pos);
        world.setBlockAndUpdate(pos, newState);
    }

    private BlockState getStateFromBlockEntity(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof HypertubeBlockEntity)) {
            return this.getState(blockState, world, pos);
        }
        HypertubeBlockEntity hypertube = (HypertubeBlockEntity)be;
        IConnection conn = hypertube.getConnectionOne();
        SimpleConnection connection = IConnection.getSameConnectionBlockPos(conn, world, pos);
        if (connection != null) {
            return this.getState(blockState, Set.of(connection.direction()), true);
        }
        conn = hypertube.getConnectionTwo();
        connection = IConnection.getSameConnectionBlockPos(conn, world, pos);
        if (connection != null) {
            return this.getState(blockState, Set.of(connection.direction()), true);
        }
        return this.getState(blockState, world, pos);
    }

    public BlockState getState(BlockState blockState, Collection<Direction> activeDirections, boolean connected) {
        if (activeDirections == null) {
            return (BlockState)((BlockState)((BlockState)blockState.setValue((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST_WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP_DOWN, (Comparable)Boolean.valueOf(false));
        }
        boolean northSouth = activeDirections.contains(Direction.NORTH) || activeDirections.contains(Direction.SOUTH);
        boolean eastWest = activeDirections.contains(Direction.EAST) || activeDirections.contains(Direction.WEST);
        boolean upDown = activeDirections.contains(Direction.UP) || activeDirections.contains(Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(northSouth))).setValue((Property)EAST_WEST, (Comparable)Boolean.valueOf(eastWest && !northSouth))).setValue((Property)UP_DOWN, (Comparable)Boolean.valueOf(upDown && !northSouth && !eastWest))).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(connected && (northSouth || eastWest || upDown)));
    }

    private BlockState getState(BlockState blockState, Level world, BlockPos pos) {
        if (blockState == null) {
            blockState = this.defaultBlockState();
        }
        boolean northSouth = this.isConnected((LevelAccessor)world, pos, Direction.NORTH) || this.isConnected((LevelAccessor)world, pos, Direction.SOUTH);
        boolean eastWest = this.isConnected((LevelAccessor)world, pos, Direction.EAST) || this.isConnected((LevelAccessor)world, pos, Direction.WEST);
        boolean upDown = this.isConnected((LevelAccessor)world, pos, Direction.UP) || this.isConnected((LevelAccessor)world, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(northSouth))).setValue((Property)EAST_WEST, (Comparable)Boolean.valueOf(eastWest && !northSouth))).setValue((Property)UP_DOWN, (Comparable)Boolean.valueOf(upDown && !northSouth && !eastWest))).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(northSouth || eastWest || upDown));
    }

    public void updateBlockStateFromEntity(BlockState state, Level world, BlockPos pos) {
        if (world.isClientSide()) {
            return;
        }
        BlockState newState = this.getStateFromBlockEntity(state, world, pos);
        this.updateBlockState(world, pos, newState);
    }

    public void updateBlockState(Level world, BlockPos pos, BlockState newState) {
        if (world.isClientSide()) {
            return;
        }
        BlockState currentState = world.getBlockState(pos);
        if (!currentState.equals(newState)) {
            world.setBlockAndUpdate(pos, newState);
        }
    }

    @Override
    public List<Direction> getConnectedFaces(BlockState state) {
        if (!((Boolean)state.getValue((Property)CONNECTED)).booleanValue()) {
            return List.of();
        }
        ArrayList<Direction> directions = new ArrayList<Direction>();
        if (((Boolean)state.getValue((Property)NORTH_SOUTH)).booleanValue()) {
            directions.add(Direction.NORTH);
            directions.add(Direction.SOUTH);
        }
        if (((Boolean)state.getValue((Property)EAST_WEST)).booleanValue()) {
            directions.add(Direction.EAST);
            directions.add(Direction.WEST);
        }
        if (((Boolean)state.getValue((Property)UP_DOWN)).booleanValue()) {
            directions.add(Direction.UP);
            directions.add(Direction.DOWN);
        }
        return directions;
    }

    @Override
    public boolean canTravelConnect(LevelAccessor world, BlockPos posSelf, Direction facing) {
        HypertubeBlock hypertubeBlock;
        BlockPos relative = posSelf.relative(facing);
        BlockState otherState = world.getBlockState(relative);
        Block block = otherState.getBlock();
        return block instanceof ITubeConnection && (!(block instanceof HypertubeBlock) || this.canOtherConnectTo(world, relative, hypertubeBlock = (HypertubeBlock)block, facing));
    }

    private boolean canOtherConnectTo(LevelAccessor world, BlockPos otherPos, HypertubeBlock otherTube, Direction facing) {
        List<Direction> connectedFaces = otherTube.getConnectedFaces(otherTube.getState(null, (Level)world, otherPos));
        return connectedFaces.isEmpty() || connectedFaces.contains(facing);
    }

    public Class<HypertubeBlockEntity> getBlockEntityClass() {
        return HypertubeBlockEntity.class;
    }

    public BlockEntityType<? extends HypertubeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.HYPERTUBE.get();
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.HYPERTUBE.get()).create(blockPos, state);
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        return this.playerWillDestroy(level, pos, state, player, false);
    }

    private BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player, boolean wrenched) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            return super.playerWillDestroy(level, pos, state, player);
        }
        ITubeConnectionEntity tube = (ITubeConnectionEntity)blockEntity;
        int toDrop = tube.blockBroken();
        if (!player.isCreative() && (toDrop != 0 || wrenched)) {
            ItemStack stack = new ItemStack((ItemLike)ModBlocks.HYPERTUBE.get(), toDrop + (wrenched ? 1 : 0));
            if (wrenched) {
                player.getInventory().placeItemBackInInventory(stack);
            } else {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!(placer instanceof Player)) {
            return;
        }
        Player player = (Player)placer;
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            return;
        }
        ITubeConnectionEntity thisConnection = (ITubeConnectionEntity)blockEntity;
        if (!stack.hasFoil()) {
            level.playSound(null, pos, this.getSoundType(state, (LevelReader)level, pos, (Entity)placer).getPlaceSound(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
            return;
        }
        SimpleConnection connectionFrom = (SimpleConnection)stack.get(ModDataComponent.TUBE_CONNECTING_FROM);
        if (connectionFrom == null) {
            return;
        }
        Direction finalDirection = RayCastUtils.getDirectionFromHitResult(player, () -> state.getBlock() instanceof ITubeConnection, true);
        SimpleConnection connectionTo = new SimpleConnection(pos, finalDirection);
        BezierConnection bezierConnection = BezierConnection.of(connectionFrom, connectionTo);
        if (!TubeUtils.checkPlayerPlacingBlockValidation(player, bezierConnection, level)) {
            level.playSound((Entity)placer, pos, (SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.BLOCKS, 1.0f, 0.5f);
            return;
        }
        BlockEntity otherBlockEntity = level.getBlockEntity(connectionFrom.pos());
        if (!(otherBlockEntity instanceof ITubeConnectionEntity)) {
            return;
        }
        ITubeConnectionEntity otherConnection = (ITubeConnectionEntity)otherBlockEntity;
        level.playSound(null, pos, this.getSoundType(state, (LevelReader)level, pos, (Entity)placer).getPlaceSound(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
        if (!otherConnection.hasConnectionAvailable()) {
            MessageUtils.sendActionMessage(player, (Component)Component.translatable((String)"placement.create_hypertube.invalid_conn").withColor(0xFF0000), true);
            return;
        }
        otherConnection.setConnection(bezierConnection, bezierConnection.getFromPos().direction());
        thisConnection.setConnection(connectionFrom, finalDirection);
        MessageUtils.sendActionMessage(player, (Component)Component.empty(), true);
        Block block = level.getBlockState(pos).getBlock();
        if (!(block instanceof HypertubeBlock)) {
            return;
        }
        HypertubeBlock hypertubeBlock = (HypertubeBlock)block;
        hypertubeBlock.updateBlockState(level, pos, hypertubeBlock.getState(state, List.of(finalDirection), true));
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return ModBlocks.HYPERTUBE.asStack();
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        return ModBlocks.HYPERTUBE.asStack();
    }

    public boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, context);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, context);
    }

    @NotNull
    public VoxelShape getBlockSupportShape(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return this.getShape(state);
    }

    @NotNull
    public VoxelShape getInteractionShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return this.getShape(state);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state) {
        return this.getShape(state, null);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        this.playerWillDestroy(world, context.getClickedPos(), state, context.getPlayer(), true);
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.getBlockState(pos), player);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return InteractionResult.SUCCESS;
        }
        world.destroyBlock(pos, false);
        IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (((Boolean)state.getValue((Property)CONNECTED)).booleanValue()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ITubeConnectionEntity) {
                ITubeConnectionEntity tube = (ITubeConnectionEntity)blockEntity;
                tube.wrenchClicked(context.getClickedFace());
            }
            this.updateAfterWrenched(state, context);
            IWrenchable.playRotateSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
            return InteractionResult.SUCCESS;
        }
        state = (Boolean)state.getValue((Property)EAST_WEST) != false ? (BlockState)((BlockState)state.setValue((Property)EAST_WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP_DOWN, (Comparable)Boolean.valueOf(true)) : ((Boolean)state.getValue((Property)UP_DOWN) != false ? (BlockState)((BlockState)state.setValue((Property)UP_DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(true)) : ((Boolean)state.getValue((Property)NORTH_SOUTH) != false ? (BlockState)((BlockState)state.setValue((Property)NORTH_SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST_WEST, (Comparable)Boolean.valueOf(true)) : this.getState(state, List.of(context.getClickedFace()), false)));
        level.playSound(player, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.75f, 1.0f);
        return super.onWrenched(state, context);
    }
}

