/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks;

import com.pedrorok.hypertube.blocks.blockentities.HyperEntranceBlockEntity;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.registry.ModBlockEntities;
import com.pedrorok.hypertube.utils.MessageUtils;
import com.pedrorok.hypertube.utils.VoxelUtils;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HyperEntranceBlock
extends KineticBlock
implements EntityBlock,
ICogWheel,
ITubeConnection,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty LOCKED = BlockStateProperties.LOCKED;
    public static final BooleanProperty IN_FRONT = BooleanProperty.create((String)"has_block_in_front");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)23.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)-7.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)-7.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)23.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_UP = Block.box((double)0.0, (double)-7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_DOWN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)23.0, (double)16.0);

    public HyperEntranceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(true))).setValue((Property)IN_FRONT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, IN_FRONT, LOCKED, WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        if (player == null) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is((Fluid)Fluids.WATER)));
        }
        Direction direction = player.getDirection();
        if (player.getXRot() < -45.0f) {
            direction = Direction.UP;
        } else if (player.getXRot() > 45.0f) {
            direction = Direction.DOWN;
        }
        boolean isFrontBlocked = false;
        BlockPos relative = context.getClickedPos().relative(direction.getOpposite());
        if (!level.getBlockState(relative).getCollisionShape((BlockGetter)level, relative).isEmpty()) {
            isFrontBlocked = true;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(true))).setValue((Property)IN_FRONT, (Comparable)Boolean.valueOf(isFrontBlocked))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is((Fluid)Fluids.WATER)));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block p_60512_, BlockPos p_60513_, boolean p_60514_) {
        super.neighborChanged(state, level, pos, p_60512_, p_60513_, p_60514_);
        this.updateInFrontProperty(level, pos, state);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        this.updateInFrontProperty((Level)level, pos, state);
    }

    public void updateInFrontProperty(Level level, BlockPos pos, BlockState state) {
        boolean isFrontBlocked = false;
        Direction facing = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockPos relative = pos.relative(facing);
        if (!level.getBlockState(relative).getCollisionShape((BlockGetter)level, relative).isEmpty()) {
            isFrontBlocked = true;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)IN_FRONT, (Comparable)Boolean.valueOf(isFrontBlocked)), 3);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return false;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return ((BlockEntityType)ModBlockEntities.HYPERTUBE_ENTRANCE.get()).create(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level1, pos, state1, be) -> ((HyperEntranceBlockEntity)be).tick();
    }

    @Override
    public boolean canTravelConnect(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.getBlockState(pos);
        return facing.getOpposite() == state.getValue((Property)FACING) && state.getBlock() instanceof HyperEntranceBlock;
    }

    @Override
    public List<Direction> getConnectedFaces(BlockState state) {
        return List.of(((Direction)state.getValue((Property)FACING)).getOpposite());
    }

    public VoxelShape getShape(BlockState state, @Nullable CollisionContext ctx) {
        EntityCollisionContext ecc;
        if (ctx instanceof EntityCollisionContext && (ecc = (EntityCollisionContext)ctx).getEntity() != null && ecc.getEntity().getPersistentData().getBoolean("hypertube_travel")) {
            return VoxelUtils.empty();
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            default -> SHAPE_NORTH;
        };
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, context);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, context);
    }

    @NotNull
    public VoxelShape getBlockSupportShape(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return this.getShape(state);
    }

    @NotNull
    public VoxelShape getInteractionShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return this.getShape(state);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state) {
        return this.getShape(state, null);
    }

    public boolean isSmallCog() {
        return true;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        HyperEntranceBlockEntity entrance;
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof HyperEntranceBlockEntity && (entrance = (HyperEntranceBlockEntity)blockEntity).wrenchClicked(context.getClickedFace())) {
            IWrenchable.playRotateSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        BlockState blockState = (BlockState)state.setValue((Property)LOCKED, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)LOCKED) == false));
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        level.setBlock(pos, blockState, 3);
        if (((Boolean)blockState.getValue((Property)LOCKED)).booleanValue()) {
            MessageUtils.sendActionMessage(player, (Component)Component.translatable((String)"block.hypertube.hyper_entrance.manual_lock").append(" (").append((Component)Component.translatable((String)"block.hypertube.hyper_entrance.sneak_to_enter")).append(")").withColor(0xFF5500), true);
        } else {
            MessageUtils.sendActionMessage(player, (Component)Component.translatable((String)"block.hypertube.hyper_entrance.automatic_lock").withColor(0x55FF00), true);
        }
        IWrenchable.playRotateSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected BlockState updateShape(BlockState p_313906_, @NotNull Direction p_313739_, @NotNull BlockState p_313829_, @NotNull LevelAccessor p_313692_, @NotNull BlockPos p_313842_, @NotNull BlockPos p_313843_) {
        if (((Boolean)p_313906_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_313692_.scheduleTick(p_313842_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_313692_));
        }
        return super.updateShape(p_313906_, p_313739_, p_313829_, p_313692_, p_313842_, p_313843_);
    }

    @NotNull
    protected FluidState getFluidState(BlockState p_313789_) {
        return (Boolean)p_313789_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(true) : super.getFluidState(p_313789_);
    }
}

