/*
 * Decompiled with CFR 0.152.
 */
package net.sirgrantd.magic_coins.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.sirgrantd.magic_coins.api.MagicCoinsApi;

@EventBusSubscriber
public class CoinsCommand {
    @SubscribeEvent
    public static void registerCoinsCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"coins").requires(s -> s.hasPermission(4))).then(Commands.literal((String)"add").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(arguments -> {
            Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
            Entity players = ((CommandSourceStack)arguments.getSource()).getEntity();
            if (players == null && world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                players = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
            }
            if (players != null) {
                // empty if block
            }
            int amount = IntegerArgumentType.getInteger((CommandContext)arguments, (String)"amount");
            Entity player = new Object(){

                public Entity getEntity() {
                    try {
                        return EntityArgument.getEntity((CommandContext)arguments, (String)"players");
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }.getEntity();
            MagicCoinsApi.addCoins(player, amount);
            return 0;
        }))))).then(Commands.literal((String)"set").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(arguments -> {
            Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
            Entity players = ((CommandSourceStack)arguments.getSource()).getEntity();
            if (players == null && world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                players = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
            }
            if (players != null) {
                // empty if block
            }
            int amount = IntegerArgumentType.getInteger((CommandContext)arguments, (String)"amount");
            Entity player = new Object(){

                public Entity getEntity() {
                    try {
                        return EntityArgument.getEntity((CommandContext)arguments, (String)"players");
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }.getEntity();
            MagicCoinsApi.setTotalCoins(player, amount);
            return 0;
        }))))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(arguments -> {
            Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
            Entity players = ((CommandSourceStack)arguments.getSource()).getEntity();
            if (players == null && world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                players = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
            }
            if (players != null) {
                // empty if block
            }
            Entity player = new Object(){

                public Entity getEntity() {
                    try {
                        return EntityArgument.getEntity((CommandContext)arguments, (String)"player");
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }.getEntity();
            MagicCoinsApi.getTotalCoins(player);
            return 0;
        }))));
    }
}

