/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc.neoforge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class ModLootConditions {
    public static final Supplier<LootItemConditionType> ICONDITION_LOOT_CONDITION = RegHelper.registerLootCondition(Moonlight.res("iconditions"), () -> IConditionLootCondition.CODEC);
    public static final Supplier<LootItemConditionType> PATTERN_MATCH_CONDITION = RegHelper.registerLootCondition(Moonlight.res("loot_table_id_patter"), () -> PatternMatchCondition.CODEC);

    public static void register() {
    }

    public record PatternMatchCondition(List<Pattern> patterns) implements LootItemCondition
    {
        public static final MapCodec<PatternMatchCondition> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ExtraCodecs.PATTERN.listOf().fieldOf("matches").forGetter(o -> o.patterns)).apply((Applicative)i, PatternMatchCondition::new));

        public boolean test(LootContext lootContext) {
            String id = lootContext.getQueriedLootTableId().toString();
            for (Pattern p : this.patterns) {
                if (id.equals(p.pattern())) {
                    return true;
                }
                if (!p.matcher(id).find()) continue;
                return true;
            }
            return false;
        }

        @Nonnull
        public LootItemConditionType getType() {
            return PATTERN_MATCH_CONDITION.get();
        }
    }

    public record IConditionLootCondition(List<ICondition> conditions) implements LootItemCondition
    {
        public static final MapCodec<IConditionLootCondition> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ICondition.LIST_CODEC.fieldOf("values").forGetter(o -> o.conditions)).apply((Applicative)i, IConditionLootCondition::new));

        public boolean test(LootContext lootContext) {
            for (ICondition c : this.conditions) {
                if (c.test(ICondition.IContext.EMPTY)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public LootItemConditionType getType() {
            return ICONDITION_LOOT_CONDITION.get();
        }
    }
}

