/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.fluid;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.IdentityHashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.fluid.neoforge.SoftFluidInternalImpl;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SoftFluidInternal {
    private static final SidedInstance<Map<Fluid, Holder<SoftFluid>>> FLUID_MAP = SidedInstance.of(r -> {
        IdentityHashMap<Fluid, Holder<SoftFluid>> m = new IdentityHashMap<Fluid, Holder<SoftFluid>>();
        SoftFluidInternal.populateFluidSlaveMap(r, m);
        return m;
    });
    private static final SidedInstance<Map<Item, Holder<SoftFluid>>> ITEM_MAP = SidedInstance.of(r -> {
        IdentityHashMap<Item, Holder<SoftFluid>> m = new IdentityHashMap<Item, Holder<SoftFluid>>();
        SoftFluidInternal.populateItemSlaveMap(r, m);
        return m;
    });

    public static Holder<SoftFluid> fromVanillaFluid(Fluid fluid, RegistryAccess registryAccess) {
        return FLUID_MAP.get((HolderLookup.Provider)registryAccess).get(fluid);
    }

    public static Holder<SoftFluid> fromVanillaItem(Item item, RegistryAccess registryAccess) {
        return ITEM_MAP.get((HolderLookup.Provider)registryAccess).get(item);
    }

    private static void populateFluidSlaveMap(HolderLookup.Provider registryAccess, Map<Fluid, Holder<SoftFluid>> fluidMap) {
        fluidMap.clear();
        for (Holder.Reference h : SoftFluidRegistry.get(registryAccess).listElements().toList()) {
            SoftFluid s = (SoftFluid)h.value();
            if (!s.isEnabled()) continue;
            for (Holder eq : s.getEquivalentFluids()) {
                Fluid value = (Fluid)eq.value();
                if (value == Fluids.EMPTY) {
                    Moonlight.LOGGER.error("!!Invalid fluid for fluid. This is a bug! {}", (Object)h);
                    if (PlatHelper.isDev()) {
                        throw new AssertionError((Object)("Invalid fluid for fluid. This is a bug! " + String.valueOf(h)));
                    }
                }
                fluidMap.put(value, (Holder<SoftFluid>)h);
            }
            s.getEquivalentFluids().forEach(f -> fluidMap.put((Fluid)f.value(), (Holder<SoftFluid>)h));
        }
    }

    private static void populateItemSlaveMap(HolderLookup.Provider registryAccess, Map<Item, Holder<SoftFluid>> itemMap) {
        itemMap.clear();
        for (Holder.Reference h : SoftFluidRegistry.get(registryAccess).listElements().toList()) {
            SoftFluid s = (SoftFluid)h.value();
            if (!s.isEnabled()) continue;
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != Items.POTION || !MLBuiltinSoftFluids.WATER.is((Holder<SoftFluid>)h)) {
                    if (i == Items.AIR) {
                        Moonlight.LOGGER.error("!!Invalid item for fluid. This is a bug! {}", (Object)h);
                        if (PlatHelper.isDev()) {
                            throw new AssertionError((Object)("Invalid item for fluid. This is a bug! " + String.valueOf(h)));
                        }
                    }
                    itemMap.put((Item)i, (Holder<SoftFluid>)h);
                }
            });
        }
    }

    public static void init() {
        RegHelper.registerDataPackRegistry(SoftFluidRegistry.KEY, SoftFluid.CODEC, SoftFluid.CODEC);
    }

    public static void postInitClient(RegistryAccess ra) {
        FLUID_MAP.get((HolderLookup.Provider)ra);
        ITEM_MAP.get((HolderLookup.Provider)ra);
        Registry<SoftFluid> reg = SoftFluidRegistry.get(ra);
        for (SoftFluid f : reg) {
            f.afterInit();
        }
        SoftFluidColors.refreshParticleColors();
    }

    public static void onDataSyncToPlayer(ServerPlayer player, boolean isJoined) {
        if (isJoined) {
            NetworkHelper.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    public static void doPostInitServer(RegistryAccess ra) {
        FLUID_MAP.get((HolderLookup.Provider)ra);
        ITEM_MAP.get((HolderLookup.Provider)ra);
        SoftFluidInternal.registerExistingVanillaFluids(ra, FLUID_MAP.get((HolderLookup.Provider)ra), ITEM_MAP.get((HolderLookup.Provider)ra));
        for (SoftFluid f : SoftFluidRegistry.get(ra)) {
            f.afterInit();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(RegistryAccess ra, Map<Fluid, Holder<SoftFluid>> fluidMap, Map<Item, Holder<SoftFluid>> itemMap) {
        void var2_2;
        void var1_1;
        SoftFluidInternalImpl.registerExistingVanillaFluids(ra, (Map<Fluid, Holder<SoftFluid>>)var1_1, (Map<Item, Holder<SoftFluid>>)var2_2);
    }
}

