/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.network.neoforge;

import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.neoforge.MoonlightForge;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;

public class NetworkHelperImpl {
    public static void addNetworkRegistration(Consumer<NetworkHelper.RegisterMessagesEvent> eventListener, int version) {
        Consumer<RegisterPayloadHandlersEvent> eventConsumer = event -> {
            String versionStr = "" + version;
            NetworkHelper.RegisterMessagesEvent registerMessagesEvent = new NetworkHelper.RegisterMessagesEvent(){
                final /* synthetic */ RegisterPayloadHandlersEvent val$event;
                final /* synthetic */ String val$versionStr;
                {
                    this.val$event = registerPayloadHandlersEvent;
                    this.val$versionStr = string;
                }

                @Override
                public <M extends Message> void registerServerBound(CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, M> messageType) {
                    this.val$event.registrar(messageType.type().id().getPath()).versioned(this.val$versionStr).executesOn(HandlerThread.MAIN).playToServer(messageType.type(), messageType.codec(), (m, c) -> m.handle(new ContextWrapper(c)));
                }

                @Override
                public <M extends Message> void registerClientBound(CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, M> messageType) {
                    this.val$event.registrar(messageType.type().id().getPath()).versioned(this.val$versionStr).executesOn(HandlerThread.MAIN).playToClient(messageType.type(), messageType.codec(), (m, c) -> m.handle(new ContextWrapper(c)));
                }

                @Override
                public <M extends Message> void registerBidirectional(CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, M> messageType) {
                    this.val$event.registrar(messageType.type().id().getPath()).versioned(this.val$versionStr).executesOn(HandlerThread.MAIN).playBidirectional(messageType.type(), messageType.codec(), (m, c) -> m.handle(new ContextWrapper(c)));
                }
            };
            eventListener.accept(registerMessagesEvent);
        };
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void sendToClientPlayer(ServerPlayer serverPlayer, CustomPacketPayload message) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAllClientPlayers(CustomPacketPayload message) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAllClientPlayersInRange(ServerLevel level, BlockPos pos, double radius, CustomPacketPayload message) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (double)radius, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAllClientPlayersTrackingEntity(Entity target, CustomPacketPayload message) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)target, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAllClientPlayersTrackingEntityAndSelf(Entity target, Message message) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)target, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(CustomPacketPayload message) {
        PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private record ContextWrapper(IPayloadContext c) implements Message.Context
    {
        @Override
        public Message.NetworkDir getDirection() {
            PacketFlow flow = this.c.connection().getDirection();
            if (flow == PacketFlow.SERVERBOUND) {
                return Message.NetworkDir.SERVER_BOUND;
            }
            return Message.NetworkDir.CLIENT_BOUND;
        }

        @Override
        public Player getPlayer() {
            return this.c.player();
        }

        @Override
        public void disconnect(Component reason) {
            this.c.disconnect(reason);
        }

        @Override
        public void reply(CustomPacketPayload payload) {
            this.c.reply(payload);
        }
    }
}

