/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.crafting.neoforge;

import com.chefmooon.ubesdelight.common.crafting.BakingMatRecipe;
import com.chefmooon.ubesdelight.common.crafting.ingredient.ChanceResult;
import com.chefmooon.ubesdelight.common.registry.neoforge.UbesDelightRecipeSerializersImpl;
import com.chefmooon.ubesdelight.common.registry.neoforge.UbesDelightRecipeTypesImpl;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class BakingMatRecipeImpl
extends BakingMatRecipe
implements Recipe<RecipeWrapper> {
    public BakingMatRecipeImpl(String group, NonNullList<Ingredient> ingredientList, NonNullList<Ingredient> processStages, Ingredient tool, NonNullList<ChanceResult> resultList, Optional<SoundEvent> soundEvent) {
        super(group, ingredientList, processStages, tool, resultList, soundEvent);
    }

    public boolean isSpecial() {
        return true;
    }

    public String getGroup() {
        return this.group;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredientList;
    }

    public NonNullList<Ingredient> getProcessStages() {
        return this.processStages;
    }

    public NonNullList<Ingredient> getIngredientsAndTool() {
        NonNullList ingredientTool = NonNullList.create();
        ingredientTool.addAll((Collection)this.ingredientList);
        ingredientTool.add((Object)this.tool);
        return this.ingredientList;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ((ChanceResult)this.resultList.get(0)).stack();
    }

    public List<ItemStack> getResultList() {
        return this.getRollableResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public ItemStack getMandatoryResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() == 1.0f).map(ChanceResult::stack).findFirst().get();
    }

    public List<ItemStack> getMandatoryResults() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() == 1.0f).map(ChanceResult::stack).toList();
    }

    public List<ChanceResult> getVariableResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() != 1.0f).toList();
    }

    public NonNullList<ChanceResult> getRollableResults() {
        return this.resultList;
    }

    public Optional<SoundEvent> getSoundEventID() {
        return this.soundEvent;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        boolean inputMatch;
        boolean processMatch = false;
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            ItemStack itemStack = inv.getItem(j);
            if (itemStack.isEmpty()) continue;
            ++i;
            inputList.add(itemStack);
        }
        boolean bl = inputMatch = i == this.ingredientList.size() && RecipeMatcher.findMatches(inputList, (List)this.ingredientList) != null;
        if (this.processStages.size() > 0 && inputList.size() > 0) {
            for (Ingredient ingredient : this.processStages) {
                if (!Arrays.stream(ingredient.getItems()).findFirst().get().is(((ItemStack)inputList.get(0)).getItem())) continue;
                processMatch = true;
            }
        }
        return inputMatch || processMatch;
    }

    public ItemStack assemble(RecipeWrapper inv, HolderLookup.Provider provider) {
        return ((ChanceResult)this.resultList.get(0)).stack().copy();
    }

    public List<ItemStack> getRollResults(RandomSource rand, int fortuneLevel) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        NonNullList<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            ItemStack stack = output.chance() == 1.0f ? output.stack() : output.rollStackOutput(rand, fortuneLevel);
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredientList.size();
    }

    public RecipeSerializer<?> getSerializer() {
        return UbesDelightRecipeSerializersImpl.BAKING_MAT.get();
    }

    public RecipeType<?> getType() {
        return UbesDelightRecipeTypesImpl.BAKING_MAT.get();
    }

    public Optional<SoundEvent> getSoundEvent() {
        return this.soundEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BakingMatRecipeImpl that = (BakingMatRecipeImpl)o;
        if (!this.getGroup().equals(that.getGroup())) {
            return false;
        }
        if (!this.ingredientList.equals((Object)that.ingredientList)) {
            return false;
        }
        if (!this.processStages.equals((Object)that.processStages)) {
            return false;
        }
        if (!this.getTool().equals((Object)that.getTool())) {
            return false;
        }
        if (!this.getResultList().equals(that.getResultList())) {
            return false;
        }
        return Objects.equals(this.soundEvent, that.soundEvent);
    }

    public int hashCode() {
        int result = this.getGroup().hashCode();
        result = 31 * result + this.ingredientList.hashCode();
        result = 31 * result + this.processStages.hashCode();
        result = 31 * result + this.getTool().hashCode();
        result = 31 * result + this.getResultList().hashCode();
        result = 31 * result + this.soundEvent.map(Object::hashCode).orElse(0);
        return result;
    }

    public static class Serializer
    implements RecipeSerializer<BakingMatRecipeImpl> {
        private static final MapCodec<BakingMatRecipeImpl> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(BakingMatRecipeImpl::getGroup), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            if (ingredients.isEmpty()) {
                return DataResult.error(() -> "No ingredients for baking recipe");
            }
            if (ingredients.size() > 9) {
                return DataResult.error(() -> "Too many ingredients for baking recipe! Max ingredients is 9");
            }
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)ingredients);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(BakingMatRecipeImpl::getIngredients), (App)Ingredient.CODEC.listOf().fieldOf("processing_stages").flatXmap(processStages -> {
            if (processStages.size() > 5) {
                return DataResult.error(() -> "Too many processing stages for baking recipe! Max processing stages is 5");
            }
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)processStages);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(BakingMatRecipeImpl::getProcessStages), (App)Ingredient.CODEC.fieldOf("tool").forGetter(BakingMatRecipeImpl::getTool), (App)Codec.list(ChanceResult.CODEC).fieldOf("result").flatXmap(chanceResults -> {
            if (chanceResults.size() > 4) {
                return DataResult.error(() -> "Too many results for baking recipe! The maximum quantity of unique results is 4");
            }
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)chanceResults);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(BakingMatRecipeImpl::getRollableResults), (App)SoundEvent.DIRECT_CODEC.optionalFieldOf("sound").forGetter(BakingMatRecipeImpl::getSoundEvent)).apply((Applicative)inst, BakingMatRecipeImpl::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BakingMatRecipeImpl> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BakingMatRecipeImpl> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BakingMatRecipeImpl> streamCodec() {
            return STREAM_CODEC;
        }

        public static BakingMatRecipeImpl fromNetwork(RegistryFriendlyByteBuf buf) {
            Optional holder;
            String groupIn = buf.readUtf(Short.MAX_VALUE);
            int i = buf.readVarInt();
            NonNullList ingredientList = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < ingredientList.size(); ++j) {
                ingredientList.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf)));
            }
            int k = buf.readVarInt();
            NonNullList processingStagesList = NonNullList.withSize((int)k, (Object)Ingredient.EMPTY);
            for (int l = 0; l < processingStagesList.size(); ++l) {
                processingStagesList.set(l, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf)));
            }
            Ingredient tool = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            int m = buf.readVarInt();
            NonNullList resultsList = NonNullList.withSize((int)m, (Object)ChanceResult.EMPTY);
            for (int n = 0; n < resultsList.size(); ++n) {
                resultsList.set(n, (Object)ChanceResult.read(buf));
            }
            Optional<SoundEvent> soundID = Optional.empty();
            if (buf.readBoolean() && (holder = BuiltInRegistries.SOUND_EVENT.getHolder(buf.readResourceKey(Registries.SOUND_EVENT))).isPresent() && ((Holder.Reference)holder.get()).isBound()) {
                soundID = Optional.of((SoundEvent)((Holder.Reference)holder.get()).value());
            }
            return new BakingMatRecipeImpl(groupIn, (NonNullList<Ingredient>)ingredientList, (NonNullList<Ingredient>)processingStagesList, tool, (NonNullList<ChanceResult>)resultsList, soundID);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, BakingMatRecipeImpl recipe) {
            buf.writeUtf(recipe.group);
            buf.writeVarInt(recipe.ingredientList.size());
            for (Ingredient ingredient : recipe.ingredientList) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
            }
            buf.writeVarInt(recipe.processStages.size());
            for (Ingredient processingStages : recipe.processStages) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)processingStages);
            }
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.tool);
            buf.writeVarInt(recipe.resultList.size());
            for (ChanceResult result : recipe.resultList) {
                result.write(buf);
            }
            if (recipe.getSoundEvent().isPresent()) {
                Optional resourceKey = BuiltInRegistries.SOUND_EVENT.getResourceKey((Object)recipe.getSoundEvent().get());
                resourceKey.ifPresentOrElse(rk -> {
                    buf.writeBoolean(true);
                    buf.writeResourceKey(rk);
                }, () -> buf.writeBoolean(false));
            } else {
                buf.writeBoolean(false);
            }
        }
    }
}

