/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.leaf_feast.base;

import com.chefmooon.ubesdelight.common.block.leaf_feast.base.LeafFeastBlock;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlockEntityTypes;
import com.chefmooon.ubesdelight.common.utility.VoxelShapeUtil;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class UniversalLeafFeastBlock
extends BaseEntityBlock
implements LeafFeastBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<UniversalLeafFeastBlock> CODEC = UniversalLeafFeastBlock.simpleCodec(UniversalLeafFeastBlock::new);
    private final VoxelShape[] CONNECT_SHAPES = VoxelShapeUtil.getRotatedShapes(NORTH_CONNECT_SHAPE);
    private final VoxelShape[] TIP_SHAPES = VoxelShapeUtil.getRotatedShapes(LEAF_NORTH_TIP_SHAPE);
    private final VoxelShape[] END_SHAPES = VoxelShapeUtil.getRotatedShapes(LEAF_NORTH_END_SHAPE);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public UniversalLeafFeastBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(1)));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        LeafFeastTypes leafFeastType = (LeafFeastTypes)((Object)state.getValue((Property)LEAF_FEAST_TYPE));
        return Shapes.or((VoxelShape)this.getConnectShape(leafFeastType, this.getConnectDirections(facing.getOpposite()), this.CONNECT_SHAPES), (VoxelShape)this.getBaseShape(leafFeastType, facing, this.TIP_SHAPES, this.END_SHAPES, LEAF_BASE_SHAPE));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        Level blockGetter = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState originBlockState = blockGetter.getBlockState(blockPos);
        Direction facing = context.getHorizontalDirection();
        Pair connectDirections = this.getConnectDirections(facing);
        BlockState rightBlockState = blockGetter.getBlockState(blockPos.relative((Direction)connectDirections.getFirst()));
        BlockState leftBlockState = blockGetter.getBlockState(blockPos.relative((Direction)connectDirections.getSecond()));
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)this.getLeafFeastType(this.connectsTo(originBlockState, leftBlockState), this.connectsTo(originBlockState, rightBlockState))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Pair connectDirections;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction == (connectDirections = this.getConnectDirections(((Direction)state.getValue((Property)FACING)).getOpposite())).getFirst() || direction == connectDirections.getSecond()) {
            LeafFeastTypes leafFeastType = this.getLeafFeastType(this.connectsTo(state, level.getBlockState(pos.relative((Direction)connectDirections.getFirst()))), this.connectsTo(state, level.getBlockState(pos.relative((Direction)connectDirections.getSecond()))));
            if ((Integer)state.getValue((Property)SERVINGS) > 3) {
                if (leafFeastType == LeafFeastTypes.END || leafFeastType == LeafFeastTypes.TIP) {
                    return (BlockState)state.setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)LeafFeastTypes.MIDDLE));
                }
                return (BlockState)state.setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType));
            }
            return (BlockState)state.setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)leafFeastType));
        }
        if (direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING, LEAF_FEAST_TYPE, SERVINGS});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Objects.requireNonNull((BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(UbesDelightBlockEntityTypes.UNIVERSAL_LEAF_FEAST)).create(pos, state);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }
}

