/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.leaf_feast.base;

import com.chefmooon.ubesdelight.common.block.state.properties.LeafFeastTypeProperty;
import com.chefmooon.ubesdelight.common.block.state.properties.UbesDelightBlockStateProperties;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightAdvancements;
import com.chefmooon.ubesdelight.common.registry.UbesDelightShapes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightSounds;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface LeafFeastBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final LeafFeastTypeProperty LEAF_FEAST_TYPE = UbesDelightBlockStateProperties.LEAF_FEAST_TYPE;
    public static final int MAX_SERVINGS = 6;
    public static final IntegerProperty SERVINGS = IntegerProperty.create((String)"servings", (int)1, (int)6);
    public static final VoxelShape LEAF_BASE_SHAPE = UbesDelightShapes.LEAF_BASE_SHAPE;
    public static final VoxelShape NORTH_CONNECT_SHAPE = UbesDelightShapes.NORTH_CONNECT_SHAPE;
    public static final VoxelShape LEAF_NORTH_TIP_SHAPE = UbesDelightShapes.LEAF_NORTH_TIP_SHAPE;
    public static final VoxelShape LEAF_NORTH_END_SHAPE = UbesDelightShapes.LEAF_NORTH_END_SHAPE;

    default public boolean placementConnectsTo(Direction direction, BlockState blockState) {
        if (this.validBlock(blockState)) {
            return direction == blockState.getValue((Property)FACING);
        }
        return false;
    }

    default public boolean connectsTo(BlockState originState, BlockState state) {
        if (this.validBlock(state) && this.validBlock(originState)) {
            return state.getValue((Property)FACING) == originState.getValue((Property)FACING);
        }
        return false;
    }

    default public boolean validBlock(BlockState state) {
        return state.getBlock() instanceof LeafFeastBlock;
    }

    default public VoxelShape getConnectShape(LeafFeastTypes leafFeastType, Pair<Direction, Direction> connectDirections, VoxelShape[] connectShapes) {
        VoxelShape shape = Shapes.empty();
        if (leafFeastType.isRightConnect()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)connectShapes[((Direction)connectDirections.getFirst()).get2DDataValue()]);
        }
        if (leafFeastType.isLeftConnect()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)connectShapes[((Direction)connectDirections.getSecond()).get2DDataValue()]);
        }
        return shape;
    }

    default public VoxelShape getBaseShape(LeafFeastTypes leafFeastType, Direction facing, VoxelShape[] tipShapes, VoxelShape[] endShapes, VoxelShape baseShape) {
        VoxelShape shape = Shapes.empty();
        shape = leafFeastType.isRightConnect() && !leafFeastType.isLeftConnect() ? Shapes.or((VoxelShape)shape, (VoxelShape)tipShapes[facing.get2DDataValue()]) : (leafFeastType.isLeftConnect() && !leafFeastType.isRightConnect() ? Shapes.or((VoxelShape)shape, (VoxelShape)endShapes[facing.get2DDataValue()]) : Shapes.or((VoxelShape)shape, (VoxelShape)baseShape));
        return shape;
    }

    default public Pair<Direction, Direction> getConnectDirections(Direction facing) {
        return Pair.of((Object)facing.getClockWise(), (Object)facing.getClockWise().getOpposite());
    }

    default public BlockState getTransformState(Block block, BlockState state) {
        return (BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)LEAF_FEAST_TYPE, (Comparable)((Object)((LeafFeastTypes)((Object)state.getValue((Property)LEAF_FEAST_TYPE)))))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
    }

    default public LeafFeastTypes getLeafFeastType(boolean leftConnect, boolean rightConnect) {
        if (rightConnect && leftConnect) {
            return LeafFeastTypes.MIDDLE;
        }
        if (rightConnect) {
            return LeafFeastTypes.TIP;
        }
        if (leftConnect) {
            return LeafFeastTypes.END;
        }
        return LeafFeastTypes.BASE;
    }

    default public void playAddSound(Level level, BlockPos pos) {
        level.playSound(null, pos, UbesDelightSounds.BLOCK_LEAF_FEAST_ADD.get(), SoundSource.PLAYERS, 0.6f, 0.75f);
    }

    default public void playRemoveSound(Level level, BlockPos pos) {
        level.playSound(null, pos, UbesDelightSounds.BLOCK_LEAF_FEAST_REMOVE.get(), SoundSource.PLAYERS, 0.6f, 0.8f);
    }

    public static void triggerConsumeAdvancement(Player player) {
        if (player instanceof ServerPlayer) {
            UbesDelightAdvancements.USE_LEAF_FEAST_CONSUME.get().trigger((ServerPlayer)player);
        }
    }

    public static void triggerInsertAdvancement(Player player) {
        if (player instanceof ServerPlayer) {
            UbesDelightAdvancements.USE_LEAF_FEAST_INSERT.get().trigger((ServerPlayer)player);
        }
    }
}

