/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block;

import com.chefmooon.ubesdelight.common.registry.UbesDelightSounds;
import com.chefmooon.ubesdelight.common.utility.TextUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DrinkableFeastBlock
extends Block {
    public static final int MAX_SERVINGS = 4;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty SERVINGS = IntegerProperty.create((String)"servings", (int)0, (int)4);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public Supplier<Item> servingItem;
    private final ParticleOptions particleData;

    public DrinkableFeastBlock(Supplier<Item> servingItem) {
        this(servingItem, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).strength(2.0f).sound(SoundType.GLASS));
    }

    public DrinkableFeastBlock(Supplier<Item> servingItem, BlockBehaviour.Properties properties) {
        super(properties);
        this.servingItem = servingItem;
        this.particleData = null;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(4)));
    }

    public DrinkableFeastBlock(Supplier<Item> servingItem, ParticleOptions particleData) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS));
        this.servingItem = servingItem;
        this.particleData = particleData;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(4)));
    }

    public IntegerProperty getServingsProperty() {
        return SERVINGS;
    }

    public int getMaxServings() {
        return 4;
    }

    public ItemStack getServingItem(BlockState state) {
        return new ItemStack((ItemLike)this.servingItem.get());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, SERVINGS});
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack serving = this.getServingItem(state);
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.is(serving.getItem())) {
            return this.addDrink(level, pos, state, player, hand);
        }
        return this.dispenseDrink(level, pos, state, player, hand);
    }

    protected ItemInteractionResult dispenseDrink(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.getValue((Property)this.getServingsProperty());
        if (servings == 0) {
            return ItemInteractionResult.FAIL;
        }
        if (servings > 0) {
            ItemStack serving = this.getServingItem(state);
            ItemStack heldItem = player.getItemInHand(hand);
            if (heldItem.is(Items.GLASS_BOTTLE)) {
                world.setBlock(pos, (BlockState)state.setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                world.playSound(null, pos, UbesDelightSounds.BLOCK_DRINKABLE_FEAST_REMOVE.get(), SoundSource.PLAYERS, 0.8f, 0.8f);
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                    if (!player.getInventory().add(serving)) {
                        player.drop(serving, false);
                    }
                }
            } else {
                player.displayClientMessage((Component)TextUtils.getTranslatable("container.punch_bowl", new Object[0]), true);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected ItemInteractionResult addDrink(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.getValue((Property)this.getServingsProperty());
        if (servings < 4) {
            ItemStack heldItem = player.getItemInHand(hand);
            ItemStack container = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            world.setBlock(pos, (BlockState)state.setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings + 1)), 3);
            world.playSound(null, pos, UbesDelightSounds.BLOCK_DRINKABLE_FEAST_ADD.get(), SoundSource.PLAYERS, 0.8f, 0.8f);
            if (!player.isCreative()) {
                heldItem.shrink(1);
                if (!player.getInventory().add(container)) {
                    player.drop(container, false);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public boolean addDrinkFromDispenser(Level world, BlockPos pos, BlockState state) {
        int servings = (Integer)state.getValue((Property)this.getServingsProperty());
        if (servings < 4) {
            world.setBlock(pos, (BlockState)state.setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings + 1)), 3);
            world.playSound(null, pos, UbesDelightSounds.BLOCK_DRINKABLE_FEAST_REMOVE.get(), SoundSource.PLAYERS, 0.8f, 0.8f);
            return true;
        }
        return false;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return DrinkableFeastBlock.getOutputSignal((Integer)state.getValue((Property)SERVINGS));
    }

    public static int getOutputSignal(int servings) {
        return servings * 2;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

