/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.networking.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tejty.gamediscs.item.custom.GamingConsoleItem;
import org.jetbrains.annotations.NotNull;

public record SetBestScorePacket(String game, int score) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetBestScorePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"update_best_score"));
    public static final StreamCodec<FriendlyByteBuf, SetBestScorePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SetBestScorePacket::game, (StreamCodec)ByteBufCodecs.INT, SetBestScorePacket::score, SetBestScorePacket::new);

    public static void updateBestScore(SetBestScorePacket payload, @NotNull IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ItemStack stack = player.getMainHandItem();
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof GamingConsoleItem) {
                GamingConsoleItem console = (GamingConsoleItem)patt0$temp;
                console.setBestScore(stack, payload.game, payload.score, (Player)player);
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<SetBestScorePacket> type() {
        return TYPE;
    }
}

