/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.item.custom;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.tejty.gamediscs.client.ClientUtils;
import net.tejty.gamediscs.component.BestScoreComponent;
import net.tejty.gamediscs.component.DataComponentRegistry;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class GamingConsoleItem
extends Item {
    public GamingConsoleItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (FMLEnvironment.dist == Dist.CLIENT && level.isClientSide()) {
            ClientUtils.openConsoleScreen();
        }
        return super.use(level, player, hand);
    }

    public static int getBestScore(ItemStack stack, String game, Player player) {
        BestScoreComponent component = (BestScoreComponent)stack.get(DataComponentRegistry.BEST_SCORE);
        if (component == null) {
            return 0;
        }
        if (component.stringUUID().equals(player.getStringUUID())) {
            return component.gameScores().getOrDefault(game, 0);
        }
        return 0;
    }

    public void setBestScore(ItemStack stack, String game, int score, Player player) {
        BestScoreComponent component = (BestScoreComponent)stack.getOrDefault(DataComponentRegistry.BEST_SCORE, (Object)new BestScoreComponent(Map.of(), player.getStringUUID()));
        if (!component.stringUUID().equals(player.getStringUUID())) {
            return;
        }
        HashMap<String, Integer> scores = new HashMap<String, Integer>(component.gameScores());
        scores.put(game, score);
        component = new BestScoreComponent(Map.copyOf(scores), component.stringUUID());
        stack.set(DataComponentRegistry.BEST_SCORE, (Object)component);
    }
}

