/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.AnimatedImage;
import net.tejty.gamediscs.games.graphics.BreakParticleRenderer;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.ParticleLevel;
import net.tejty.gamediscs.games.util.Sprite;

public class RabbitGame
extends Game {
    private Sprite rabbit = new Sprite(new Vec2(10.0f, 100.0f), new Vec2(16.0f, 16.0f), new AnimatedImage(ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/games/sprite/rabbit_run.png"), 16, 48, 3, 2));
    private List<Sprite> cactus = new ArrayList<Sprite>();
    private final Sprite ground = new Sprite(new Vec2(0.0f, 84.0f), new Vec2(156.0f, 16.0f), ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/games/sprite/sand_ground.png"));
    private int cactusSpawnTimer = 0;
    private float speed = -3.0f;

    @Override
    public void prepare() {
        super.prepare();
        this.rabbit = new Sprite(new Vec2(10.0f, 100.0f - this.ground.getHeight() - 16.0f), new Vec2(16.0f, 16.0f), new AnimatedImage(ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/games/sprite/rabbit_run.png"), 16, 48, 3, 2));
        this.cactus = new ArrayList<Sprite>();
        this.speed = -3.0f;
        this.ground.setVelocity(new Vec2(this.speed, 0.0f));
        this.rabbit.show();
    }

    @Override
    public void start() {
        super.start();
        this.cactusSpawnTimer = 0;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.stage != GameStage.DIED) {
            this.rabbit.animTick();
        }
        if (this.stage != GameStage.DIED && this.stage != GameStage.WON) {
            this.ground.tick();
            if (this.ground.getX() <= -16.0f) {
                this.ground.moveBy(new Vec2(16.0f, 0.0f));
            }
        }
    }

    @Override
    public void gameTick() {
        super.gameTick();
        this.rabbit.tick();
        this.rabbit.addVelocity(new Vec2(0.0f, 1.0f));
        this.speed -= 0.005f;
        this.ground.setVelocity(new Vec2(this.speed, 0.0f));
        if (this.cactusSpawnTimer <= 0) {
            this.spawnCactus();
            this.cactusSpawnTimer = this.random.nextInt(15, 30);
        }
        if (this.ticks % 20 == 0) {
            ++this.score;
        }
        for (int i = 0; i < this.cactus.size(); ++i) {
            Sprite obstacle = this.cactus.get(i);
            obstacle.tick();
            if (obstacle.getX() + obstacle.getWidth() < 0.0f) {
                this.cactus.remove(obstacle);
                --i;
            }
            if (this.rabbit.isTouching(obstacle)) {
                this.die();
            }
            obstacle.setVelocity(new Vec2(this.speed, 0.0f));
        }
        if (this.rabbit.isTouching(this.ground)) {
            this.rabbit.setY(100.0f - this.ground.getHeight() - this.rabbit.getHeight());
            this.rabbit.setVelocity(Vec2.ZERO);
        }
        --this.cactusSpawnTimer;
    }

    @Override
    public void die() {
        super.die();
        this.rabbit.hide();
        this.spawnParticleExplosion(() -> new BreakParticleRenderer(ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/games/sprite/rabbit.png"), 10, 32), this.rabbit.getCenterPos(), 20, 2, 10, ParticleLevel.GAME);
    }

    private void spawnCactus() {
        this.cactus.add(new Sprite(new Vec2(140.0f, 100.0f - this.ground.getHeight() - 10.0f), new Vec2(8.0f, 16.0f), ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/games/sprite/cactus.png")));
        this.cactus.get(this.cactus.size() - 1).setVelocity(new Vec2(this.speed, 0.0f));
    }

    @Override
    public void render(GuiGraphics graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        if (this.rabbit != null) {
            this.rabbit.render(graphics, posX, posY);
        }
        for (Sprite obstacle : this.cactus) {
            obstacle.render(graphics, posX, posY);
        }
        this.ground.render(graphics, posX, posY);
        this.renderParticles(graphics, posX, posY);
        this.renderOverlay(graphics, posX, posY);
    }

    @Override
    public void buttonDown(Button button) {
        super.buttonDown(button);
        if (button.isActionButton() && this.rabbit.getY() >= 100.0f - this.ground.getHeight() - this.rabbit.getHeight()) {
            this.rabbit.setVelocity(new Vec2(0.0f, -6.0f));
            if (this.stage == GameStage.PLAYING) {
                this.soundPlayer.playJump();
            }
        }
    }

    @Override
    public ResourceLocation getBackground() {
        return ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/games/background/rabbit_background.png");
    }

    @Override
    public boolean showScoreBox() {
        return false;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"gamediscs.rabbit");
    }

    @Override
    public ResourceLocation getIcon() {
        return ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/item/game_disc_rabbit.png");
    }
}

