/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.tejty.gamediscs.client.ClientUtils;
import net.tejty.gamediscs.client.screen.VisualButton;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.item.custom.GameDiscItem;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GamingConsoleScreen
extends Screen {
    private static final ResourceLocation BACKGROUD = ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/gui/gaming_console.png");
    private static final int CONSOLE_WIDTH = 160;
    private static final int CONSOLE_HEIGHT = 198;
    private static final int SCREEN_X = 10;
    private static final int SCREEN_Y = 10;
    private static final int W = 87;
    private static final int S = 83;
    private static final int A = 65;
    private static final int D = 68;
    private static final int SPACE = 32;
    private static final int ENTER = 257;
    private static final VisualButton W_BUTTON = new VisualButton(BACKGROUD, 256, 256, 33, 121, 14, 24, 183, 0, 24);
    private static final VisualButton A_BUTTON = new VisualButton(BACKGROUD, 256, 256, 17, 137, 23, 15, 160, 0, 24);
    private static final VisualButton D_BUTTON = new VisualButton(BACKGROUD, 256, 256, 40, 137, 23, 15, 197, 0, 24);
    private static final VisualButton S_BUTTON = new VisualButton(BACKGROUD, 256, 256, 33, 145, 14, 23, 220, 0, 24);
    private static final VisualButton B1_BUTTON = new VisualButton(BACKGROUD, 256, 256, 96, 136, 16, 16, 234, 0, 24);
    private static final VisualButton B2_BUTTON = new VisualButton(BACKGROUD, 256, 256, 128, 128, 16, 16, 234, 0, 24);
    private List<Game> availableGames = new ArrayList<Game>();
    private int selected = 0;
    private Game game = new Game();

    private int getConsoleX() {
        return (this.width - 160) / 2;
    }

    private int getConsoleY() {
        return (this.height - 198) / 2;
    }

    public GamingConsoleScreen(Component title) {
        super(title);
        this.availableGames = this.scanForGames();
    }

    public void tick() {
        if (this.game != null) {
            this.game.tick();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderGameScreen(graphics, this.getConsoleX() + 10, this.getConsoleY() + 10);
        this.renderButtons(graphics);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.blit(BACKGROUD, this.getConsoleX(), this.getConsoleY(), 0, 0.0f, 0.0f, 160, 198, 256, 256);
    }

    private void renderGameScreen(GuiGraphics graphics, int x, int y) {
        graphics.enableScissor(x, y, x + 140, y + 100);
        if (!this.game.isEmpty()) {
            this.game.render(graphics, x, y);
        } else {
            this.renderGameSelection(graphics, x, y);
        }
        graphics.disableScissor();
    }

    private void renderGameSelection(GuiGraphics graphics, int x, int y) {
        if (!this.availableGames.isEmpty()) {
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/gui/selected.png");
            Objects.requireNonNull(this.font);
            graphics.blit(resourceLocation, x, y + 3 + 9 + 18 * this.selected - Math.max(0, this.selected - 3) * 18, 0, 0.0f, 0.0f, 140, 18, 140, 18);
        }
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.gamingconsole.select_game").withStyle(ChatFormatting.BOLD), x + (140 - this.font.width(Component.translatable((String)"gui.gamingconsole.select_game").withStyle(ChatFormatting.BOLD).getVisualOrderText())) / 2, y + 3 - Math.max(0, this.selected - 3) * 18, 11330875, false);
        for (int i = 0; i < this.availableGames.size(); ++i) {
            MutableComponent mutableComponent = Component.literal((String)this.availableGames.get(i).getName().getString()).withStyle(new ChatFormatting[]{this.availableGames.get(i).getColor(), i == this.selected ? ChatFormatting.BOLD : ChatFormatting.ITALIC});
            Objects.requireNonNull(this.font);
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)mutableComponent, x + 22, y + 4 + 9 + 18 * i + (18 - 9) / 2 - Math.max(0, this.selected - 3) * 18, this.availableGames.get(i).getColor().getColor().intValue(), false);
            ResourceLocation resourceLocation = this.availableGames.get(i).getIcon();
            Objects.requireNonNull(this.font);
            graphics.blit(resourceLocation, x + 3, y + 4 + 9 + 18 * i - Math.max(0, this.selected - 3) * 18, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    private void renderButtons(GuiGraphics graphics) {
        W_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.UP));
        A_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.LEFT));
        D_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.RIGHT));
        S_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.DOWN));
        B1_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.BUTTON1));
        B2_BUTTON.render(graphics, this.getConsoleX(), this.getConsoleY(), this.game.controls.isButtonDown(Button.BUTTON2));
    }

    public List<Game> scanForGames() {
        ArrayList<Game> games = new ArrayList<Game>();
        Player player = (Player)Objects.requireNonNull(Minecraft.getInstance().player);
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            Item item = player.getInventory().getItem(i).getItem();
            if (!(item instanceof GameDiscItem)) continue;
            GameDiscItem disc = (GameDiscItem)item;
            games.add(ClientUtils.newGameFor(disc));
        }
        return games;
    }

    public boolean keyPressed(int key, int pScanCode, int pModifiers) {
        boolean flag = false;
        if (!this.game.isEmpty()) {
            if (key == 81) {
                this.game = new Game();
                flag = true;
                this.game.soundPlayer.playConfirm();
            } else if (key == 82) {
                this.game.prepare();
                flag = true;
                this.game.soundPlayer.playConfirm();
            }
        } else if (key == 81) {
            this.minecraft.setScreen(null);
            return true;
        }
        if (this.game != null) {
            switch (key) {
                case 87: {
                    this.game.controls.setButton(Button.UP, true);
                    flag = true;
                    break;
                }
                case 83: {
                    this.game.controls.setButton(Button.DOWN, true);
                    flag = true;
                    break;
                }
                case 65: {
                    this.game.controls.setButton(Button.LEFT, true);
                    flag = true;
                    break;
                }
                case 68: {
                    this.game.controls.setButton(Button.RIGHT, true);
                    flag = true;
                    break;
                }
                case 32: {
                    this.game.controls.setButton(Button.BUTTON1, true);
                    flag = true;
                    break;
                }
                case 257: {
                    this.game.controls.setButton(Button.BUTTON2, true);
                    flag = true;
                }
            }
        }
        if (this.game.isEmpty()) {
            int newSelected;
            if (key == 87) {
                newSelected = this.selected - 1;
                if (newSelected < 0) {
                    newSelected = this.availableGames.size() - 1;
                }
                this.selected = newSelected;
                flag = true;
                this.game.soundPlayer.playSelect();
            }
            if (key == 83) {
                newSelected = this.selected + 1;
                if (newSelected > this.availableGames.size() - 1) {
                    newSelected = 0;
                }
                this.selected = newSelected;
                flag = true;
                this.game.soundPlayer.playSelect();
            }
            if (!(key != 32 && key != 257 || this.availableGames.isEmpty())) {
                Game newGame = this.availableGames.get(this.selected);
                newGame.prepare();
                this.game = newGame;
                flag = true;
                this.game.soundPlayer.playConfirm();
            }
        }
        return super.keyPressed(key, pScanCode, pModifiers) || flag;
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        boolean flag = false;
        if (this.game != null) {
            switch (pKeyCode) {
                case 87: {
                    this.game.controls.setButton(Button.UP, false);
                    flag = true;
                    break;
                }
                case 83: {
                    this.game.controls.setButton(Button.DOWN, false);
                    flag = true;
                    break;
                }
                case 65: {
                    this.game.controls.setButton(Button.LEFT, false);
                    flag = true;
                    break;
                }
                case 68: {
                    this.game.controls.setButton(Button.RIGHT, false);
                    flag = true;
                    break;
                }
                case 32: {
                    this.game.controls.setButton(Button.BUTTON1, false);
                    flag = true;
                    break;
                }
                case 257: {
                    this.game.controls.setButton(Button.BUTTON2, false);
                    flag = true;
                }
            }
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers) || flag;
    }

    public void onClose() {
        super.onClose();
        this.game = null;
    }
}

