/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.mixins.features;

import com.telepathicgrunt.repurposedstructures.modinit.RSTags;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.VinesFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VinesFeature.class})
public class NoVinesInStructuresMixin {
    @Inject(method={"place(Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/Direction;values()[Lnet/minecraft/core/Direction;")}, cancellable=true)
    private void repurposedstructures_noLavaInStructures(FeaturePlaceContext<NoneFeatureConfiguration> context, CallbackInfoReturnable<Boolean> cir) {
        WorldGenLevel worldGenLevel = context.level();
        if (!(worldGenLevel instanceof WorldGenRegion)) {
            return;
        }
        WorldGenRegion worldGenRegion = (WorldGenRegion)worldGenLevel;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction face : Direction.Plane.HORIZONTAL) {
            mutable.set((Vec3i)context.origin()).move(face);
            Registry structureRegistry = (Registry)worldGenRegion.registryAccess().registry(Registries.STRUCTURE).get();
            List<StructureStart> structureStarts = GeneralUtils.inboundsValidStartsForAllStructure(worldGenRegion, (BlockPos)mutable, struct -> structureRegistry.getHolderOrThrow((ResourceKey)structureRegistry.getResourceKey(struct).get()).is(RSTags.NO_JUNGLE_VINES));
            if (structureStarts.isEmpty()) continue;
            cir.setReturnValue((Object)false);
            return;
        }
    }
}

