/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.config;

import com.corosus.watut.WatutMod;
import com.corosus.watut.config.HeldItemArmAdjustment;
import com.corosus.watut.config.HeldItemArmAdjustmentLists;
import com.google.gson.Gson;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class CustomArmCorrections {
    private static HeldItemArmAdjustmentLists heldItemArmAdjustmentLists = null;

    public static boolean loadJsonConfigs() {
        Gson gson = new Gson();
        try (FileReader reader = new FileReader("./config/" + WatutMod.configJSONName);){
            heldItemArmAdjustmentLists = (HeldItemArmAdjustmentLists)gson.fromJson((Reader)reader, HeldItemArmAdjustmentLists.class);
        }
        catch (IOException e) {
            System.out.println("FAILED TO LOAD watut-item-arm-adjustments.json, check its formatting!");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static HeldItemArmAdjustmentLists getHeldItemArmAdjustmentLists() {
        return heldItemArmAdjustmentLists;
    }

    public static Vector3f getAdjustmentForArm(ItemStack stackMainArm, ItemStack stackotherHandArm, EquipmentSlot equipmentSlot) {
        if (CustomArmCorrections.getHeldItemArmAdjustmentLists() == null) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        try {
            for (HeldItemArmAdjustment heldItemArmAdjustment : CustomArmCorrections.getHeldItemArmAdjustmentLists().getHeldItemArmAdjustments()) {
                boolean shouldMatchmatchingHand = heldItemArmAdjustment.getAdjustment().getmatchingHandX() != "0" || heldItemArmAdjustment.getAdjustment().getmatchingHandY() != "0" || heldItemArmAdjustment.getAdjustment().getmatchingHandZ() != "0";
                boolean shouldMatchotherHand = heldItemArmAdjustment.getAdjustment().getotherHandX() != "0" || heldItemArmAdjustment.getAdjustment().getotherHandY() != "0" || heldItemArmAdjustment.getAdjustment().getotherHandZ() != "0";
                boolean matchmatchingHand = shouldMatchmatchingHand && CustomArmCorrections.filterMatches(heldItemArmAdjustment, stackMainArm);
                boolean matchotherHand = shouldMatchotherHand && CustomArmCorrections.filterMatches(heldItemArmAdjustment, stackotherHandArm);
                boolean modIDMatches = heldItemArmAdjustment.getOnly_if_mod_installed().equals("") || WatutMod.instance().isModInstalled(heldItemArmAdjustment.getOnly_if_mod_installed());
                boolean matchFound = (matchmatchingHand || matchotherHand) && modIDMatches;
                if (!matchFound) continue;
                float adjX = 0.0f;
                float adjY = 0.0f;
                float adjZ = 0.0f;
                if (matchmatchingHand) {
                    adjX = heldItemArmAdjustment.getAdjustment().getmatchingHandX().toLowerCase().startsWith("disable") ? Float.MAX_VALUE : Float.parseFloat(heldItemArmAdjustment.getAdjustment().getmatchingHandX());
                    adjY = heldItemArmAdjustment.getAdjustment().getmatchingHandY().toLowerCase().startsWith("disable") ? Float.MAX_VALUE : Float.parseFloat(heldItemArmAdjustment.getAdjustment().getmatchingHandY());
                    adjZ = heldItemArmAdjustment.getAdjustment().getmatchingHandZ().toLowerCase().startsWith("disable") ? Float.MAX_VALUE : Float.parseFloat(heldItemArmAdjustment.getAdjustment().getmatchingHandZ());
                } else if (matchotherHand) {
                    adjX = heldItemArmAdjustment.getAdjustment().getotherHandX().toLowerCase().startsWith("disable") ? Float.MAX_VALUE : Float.parseFloat(heldItemArmAdjustment.getAdjustment().getotherHandX());
                    adjY = heldItemArmAdjustment.getAdjustment().getotherHandY().toLowerCase().startsWith("disable") ? Float.MAX_VALUE : Float.parseFloat(heldItemArmAdjustment.getAdjustment().getotherHandY());
                    adjZ = heldItemArmAdjustment.getAdjustment().getotherHandZ().toLowerCase().startsWith("disable") ? Float.MAX_VALUE : Float.parseFloat(heldItemArmAdjustment.getAdjustment().getotherHandZ());
                }
                return new Vector3f(adjX == Float.MAX_VALUE ? adjX : (float)Math.PI / 180 * adjX, adjY == Float.MAX_VALUE ? adjY : (float)Math.PI / 180 * adjY, adjZ == Float.MAX_VALUE ? adjZ : (float)Math.PI / 180 * adjZ);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    private static boolean filterMatches(HeldItemArmAdjustment heldItemArmAdjustment, ItemStack stack) {
        boolean matchFound = false;
        for (String filter : heldItemArmAdjustment.getFilters()) {
            String search;
            String fullname = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
            if (fullname.matches("minecraft:air")) continue;
            String modID = fullname.split(":")[0];
            String name = fullname.split(":")[1];
            if (filter.contains("@") && filter.substring(1).equals(modID)) {
                matchFound = true;
                break;
            }
            if (filter.equals(fullname)) {
                matchFound = true;
                break;
            }
            if (filter.startsWith("*") && filter.endsWith("*")) {
                search = filter.replace("*", "").replace("*", "");
                if (!fullname.contains(search)) continue;
                matchFound = true;
                break;
            }
            if (filter.startsWith("*")) {
                search = filter.replace("*", "");
                if (!fullname.endsWith(search)) continue;
                matchFound = true;
                break;
            }
            if (!filter.endsWith("*") || !fullname.startsWith(search = filter.replace("*", ""))) continue;
            matchFound = true;
            break;
        }
        return matchFound;
    }
}

