/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.integration.woodworks;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.client.render.ChiseledBookShelf;
import io.github.mortuusars.scholar.integration.woodworks.neoforge.WoodworksIntegrationImpl;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class WoodworksIntegration {
    public static void registerBlockColors(BiConsumer<BlockColor, Block> consumer) {
        Scholar.LOGGER.info("Registering chiseled bookshelf block colors to 'Woodworks'. If Woodworks bookshelves displaying wrongly - try without Scholar installed, and if incompatibility is confirmed - report to Scholar github.");
        WoodworksIntegration.getChiseledBookshelves().forEach(block -> consumer.accept(ChiseledBookShelf::getSlotTintColor, (Block)block));
    }

    public static void setRenderLayer(BiConsumer<Block, RenderType> consumer) {
        Scholar.LOGGER.info("Setting 'cutout' render type for 'Woodworks'. If Woodworks bookshelves displaying wrongly - try without Scholar installed, and if incompatibility is confirmed - report to Scholar github.");
        WoodworksIntegration.getChiseledBookshelves().forEach(block -> consumer.accept((Block)block, RenderType.cutout()));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<Block> getChiseledBookshelves() {
        return WoodworksIntegrationImpl.getChiseledBookshelves();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static OptionalInt getDefaultTintColor(BlockState state, int slot) {
        void var1_1;
        return WoodworksIntegrationImpl.getDefaultTintColor(state, (int)var1_1);
    }
}

