/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen.view;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.book.BookColor;
import io.github.mortuusars.scholar.client.gui.screen.view.BookViewAccess;
import io.github.mortuusars.scholar.client.gui.screen.view.SpreadBookViewScreen;
import io.github.mortuusars.scholar.menu.LecternSpreadMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LecternSpreadBookViewScreen
extends SpreadBookViewScreen
implements MenuAccess<LecternSpreadMenu> {
    protected final LecternSpreadMenu menu;
    protected final ContainerListener listener = new ContainerListener(){

        public void slotChanged(AbstractContainerMenu menu, int dataSlotIndex, ItemStack stack) {
            LecternSpreadBookViewScreen.this.bookChanged(stack);
        }

        public void dataChanged(AbstractContainerMenu menu, int dataSlotIndex, int pageIndex) {
            if (dataSlotIndex == 0) {
                LecternSpreadBookViewScreen.this.updatePage(pageIndex);
            }
        }
    };

    public LecternSpreadBookViewScreen(LecternSpreadMenu lecternSpreadMenu, Inventory inventory, Component component) {
        super(BookViewAccess.fromItem(lecternSpreadMenu.getBook()), BookColor.of(lecternSpreadMenu.getBook()));
        this.menu = lecternSpreadMenu;
    }

    @NotNull
    public LecternSpreadMenu getMenu() {
        return this.menu;
    }

    @Override
    protected void init() {
        super.init();
        this.getMenu().addSlotListener(this.listener);
    }

    @Override
    protected void createBottomButtons() {
        if (this.player.mayBuild()) {
            if (((Boolean)Config.Client.SHOW_DONE_BUTTON.get()).booleanValue()) {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 100, this.topPos + 180 + 12, 98, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"lectern.take_book"), button -> this.sendButtonClick(3)).bounds(this.width / 2 + 2, this.topPos + 180 + 12, 98, 20).build());
            } else {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"lectern.take_book"), button -> this.sendButtonClick(3)).bounds(this.width / 2 - 60, this.topPos + 180 + 12, 120, 20).build());
            }
        } else {
            super.createBottomButtons();
        }
    }

    @Override
    protected boolean pageBack() {
        this.sendButtonClick(1);
        return true;
    }

    @Override
    protected boolean pageForward() {
        this.sendButtonClick(2);
        return true;
    }

    @Override
    public boolean setPage(int pageIndex) {
        if (pageIndex != this.getMenu().getPage()) {
            this.sendPageIndex(pageIndex);
            return true;
        }
        return false;
    }

    protected void bookChanged(ItemStack stack) {
        this.setBookAccess(BookViewAccess.fromItem(stack));
    }

    protected void updatePage(int pageIndex) {
        super.setPage(pageIndex);
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPageTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderLeftPageNumber(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int currentSpread, int color) {
        if (this.isRightPage(this.getMenu().getPage()) && this.isHoveringOverLeftPageNumber(mouseX, mouseY)) {
            color = this.textColor;
        }
        super.renderLeftPageNumber(guiGraphics, mouseX, mouseY, partialTick, currentSpread, color);
    }

    @Override
    protected void renderRightPageNumber(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int currentSpread, int color) {
        int page = this.getMenu().getPage();
        if (page < this.getPageCount() - 1 && this.isLeftPage(page) && this.isHoveringOverRightPageNumber(mouseX, mouseY)) {
            color = this.textColor;
        }
        super.renderRightPageNumber(guiGraphics, mouseX, mouseY, partialTick, currentSpread, color);
    }

    protected void renderPageTooltip(GuiGraphics guiGraphics, int x, int y) {
        int page = this.getMenu().getPage();
        if (this.isRightPage(page) && this.isHoveringOverLeftPageNumber(x, y) || page < this.getPageCount() - 1 && this.isLeftPage(page) && this.isHoveringOverRightPageNumber(x, y)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.scholar.lectern.set_current_page"), x, y);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int page = this.getMenu().getPage();
        if (this.isRightPage(page) && this.isHoveringOverLeftPageNumber(mouseX, mouseY)) {
            this.sendButtonClick(100 + page - 1);
        } else if (page < this.getPageCount() - 1 && this.isLeftPage(page) && this.isHoveringOverRightPageNumber(mouseX, mouseY)) {
            this.sendButtonClick(100 + page + 1);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void removed() {
        super.removed();
        this.getMenu().removeSlotListener(this.listener);
    }

    public void onClose() {
        this.player.closeContainer();
        super.onClose();
    }

    protected void sendPageIndex(int pageIndex) {
        this.sendButtonClick(100 + pageIndex);
    }

    protected void sendButtonClick(int buttonId) {
        if (Minecraft.getInstance().gameMode != null) {
            Minecraft.getInstance().gameMode.handleInventoryButtonClick(this.menu.containerId, buttonId);
        }
    }
}

