/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.moped.entity;

import io.netty.buffer.Unpooled;
import net.mcreator.moped.init.MopedModItems;
import net.mcreator.moped.procedures.CopperMopedOnEntityTickUpdateProcedure;
import net.mcreator.moped.procedures.TinyCopperMopedEntityDiesProcedure;
import net.mcreator.moped.world.inventory.MopedGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityHandsInvWrapper;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TinyCopperMopedEntity
extends PathfinderMob
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(TinyCopperMopedEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(TinyCopperMopedEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(TinyCopperMopedEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Float> DATA_steeringAngle = SynchedEntityData.defineId(TinyCopperMopedEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private final ItemStackHandler inventory = new ItemStackHandler(this, 4){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

    public TinyCopperMopedEntity(EntityType<TinyCopperMopedEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"moped0");
        builder.define(DATA_steeringAngle, (Object)Float.valueOf(0.0f));
    }

    public float getSteeringAngle() {
        return ((Float)this.entityData.get(DATA_steeringAngle)).floatValue();
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-0.15f, 0.0);
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"moped:moped.sound.silence")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"moped:moped.hurt2"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"moped:moped.breaks2"));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return super.hurt(source, amount / 5.0f);
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (source.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        TinyCopperMopedEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public CombinedInvWrapper getInventory() {
        return this.combined;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.isEmpty() || EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.spawnAtLocation(itemstack);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("InventoryCustom", (Tag)this.inventory.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        compound.putString("Texture", this.getTexture());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        Tag inventoryCustom = compound.get("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)inventoryCustom;
            this.inventory.deserializeNBT((HolderLookup.Provider)this.registryAccess(), inventoryTag);
        }
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
    }

    public InteractionResult mobInteract(final Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        if (itemstack.getItem() == MopedModItems.MOPED_KEY.get()) {
            if (sourceentity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)sourceentity;
                serverPlayer.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.literal((String)"Tiny Copper Moped");
                    }

                    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                        packetBuffer.writeBlockPos(sourceentity.blockPosition());
                        packetBuffer.writeByte(0);
                        packetBuffer.writeVarInt(TinyCopperMopedEntity.this.getId());
                        return new MopedGUIMenu(id, inventory, packetBuffer);
                    }
                }, buf -> {
                    buf.writeBlockPos(sourceentity.blockPosition());
                    buf.writeByte(0);
                    buf.writeVarInt(this.getId());
                });
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        super.mobInteract(sourceentity, hand);
        sourceentity.setYRot(this.getYRot());
        sourceentity.yRotO = this.getYRot();
        sourceentity.startRiding((Entity)this);
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        CopperMopedOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public void travel(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (this.isVehicle()) {
            double d0;
            double d1;
            float f1;
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float forward = passenger.zza;
                float strafe = passenger.xxa;
                float rotationSpeed = 3.0f;
                float reverse = 1.0f;
                if (forward < 0.0f) {
                    reverse *= -1.0f;
                }
                this.setYRot(this.getYRot() - strafe * rotationSpeed * reverse);
                this.yRotO = this.getYRot();
                this.yBodyRot = this.getYRot();
                this.yHeadRot = this.getYRot();
                passenger.setYRot(passenger.getYRot() - strafe * rotationSpeed * reverse);
                passenger.yRotO = passenger.getYRot();
                super.travel(new Vec3(0.0, 0.0, (double)forward));
                float targetAngle = strafe * rotationSpeed * 20.0f;
                this.entityData.set(DATA_steeringAngle, (Object)Float.valueOf(Mth.lerp((float)0.5f, (float)this.getSteeringAngle(), (float)Mth.clamp((float)targetAngle, (float)-20.0f, (float)20.0f))));
                float carYaw = this.getYRot();
                float playerYaw = passenger.getYRot();
                float angleDiff = Mth.wrapDegrees((float)(carYaw - playerYaw));
                float maxYawOffset = 75.0f;
                if (angleDiff > maxYawOffset) {
                    float clampedYaw = carYaw - maxYawOffset;
                    passenger.setYRot(clampedYaw);
                    passenger.yRotO = clampedYaw;
                } else if (angleDiff < -maxYawOffset) {
                    float clampedYaw = carYaw + maxYawOffset;
                    passenger.setYRot(clampedYaw);
                    passenger.yRotO = clampedYaw;
                }
            }
            if ((f1 = (float)Math.sqrt((d1 = this.getX() - this.xo) * d1 + (d0 = this.getZ() - this.zo) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.walkAnimation.setSpeed(this.walkAnimation.speed() + (f1 - this.walkAnimation.speed()) * 0.4f);
            this.walkAnimation.position(this.walkAnimation.position() + this.walkAnimation.speed());
            this.calculateEntityAnimation(true);
            return;
        }
        this.entityData.set(DATA_steeringAngle, (Object)Float.valueOf(Mth.lerp((float)0.5f, (float)this.getSteeringAngle(), (float)Mth.clamp((float)0.0f, (float)-20.0f, (float)20.0f))));
        super.travel(dir);
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 6.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (this.isVehicle() && event.isMoving()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.copper_moped.moving"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.copper_moped.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        TinyCopperMopedEntity entity = this;
        Level world = entity.level();
        boolean loop = false;
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!loop && this.lastloop) {
            this.lastloop = false;
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            event.getController().forceAnimationReset();
            return PlayState.STOP;
        }
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            if (!loop) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
                if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                    this.animationprocedure = "empty";
                    event.getController().forceAnimationReset();
                }
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop(this.animationprocedure));
                this.lastloop = true;
            }
        }
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

