/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.networking;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.dawnoftime.armoroftheages.config.AOTAConfig;
import org.dawnoftime.armoroftheages.config.PreferredModel;
import org.dawnoftime.armoroftheages.networking.ConfigSyncNetworkHandler;
import org.dawnoftime.armoroftheages.networking.packets.C2SDisablePreferencesPacket;
import org.dawnoftime.armoroftheages.networking.packets.C2SPreferenceSyncPacket;
import org.dawnoftime.armoroftheages.networking.packets.S2CPreferenceSyncPacket;

public class NeoforgeConfigSyncNetworkHandler
implements ConfigSyncNetworkHandler {
    private final HashMap<UUID, PreferredModel> CURRENT_SERVER_STATE = new HashMap();
    private Consumer<HashMap<UUID, PreferredModel>> mapHandler = null;

    @Override
    public void syncConfig() {
        try {
            if (Minecraft.getInstance().level == null) {
                return;
            }
        }
        catch (Exception ignored) {
            return;
        }
        if (!AOTAConfig.get().usePreferredModel) {
            PacketDistributor.sendToServer((CustomPacketPayload)new C2SDisablePreferencesPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new C2SPreferenceSyncPacket(AOTAConfig.get().preferredModel), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void registerHandler(Consumer<HashMap<UUID, PreferredModel>> handler) {
        this.mapHandler = handler;
    }

    @Override
    public void setup() {
    }

    public void handle(S2CPreferenceSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> this.mapHandler.accept(new HashMap<UUID, PreferredModel>(packet.modelHashMap())));
    }

    public void handle(C2SPreferenceSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            this.CURRENT_SERVER_STATE.put(context.player().getUUID(), packet.preferredModel());
            this.globalSync();
        });
    }

    public void handle(C2SDisablePreferencesPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            this.CURRENT_SERVER_STATE.remove(context.player().getUUID());
            this.globalSync();
        });
    }

    private void globalSync() {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new S2CPreferenceSyncPacket(this.CURRENT_SERVER_STATE), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

