/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import org.dawnoftime.armoroftheages.client.ArmorModelProvider;
import org.dawnoftime.armoroftheages.registry.ModelProviderRegistry;
import org.jetbrains.annotations.NotNull;

public class HumanoidArmorItem
extends ArmorItem {
    private final String armorPartName;

    public HumanoidArmorItem(@NotNull String armorSetName, Holder<ArmorMaterial> material, ArmorItem.Type type, int durabilityFactor) {
        super(material, type, new Item.Properties().stacksTo(1).durability(type.getDurability(durabilityFactor)));
        this.armorPartName = armorSetName + "_" + type.getSlot().getName();
    }

    public ArmorModelProvider getModelProvider() {
        return ModelProviderRegistry.REGISTRY.get(this.armorPartName);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltips, flagIn);
        if (((Ingredient)((ArmorMaterial)this.material.value()).repairIngredient().get()).getItems().length > 0) {
            MutableComponent text = Component.translatable((String)"tooltip.armoroftheages.repair_with").withStyle(ChatFormatting.GRAY).append((Component)((Ingredient)((ArmorMaterial)this.material.value()).repairIngredient().get()).getItems()[0].getHoverName().plainCopy().withStyle(ChatFormatting.YELLOW));
            tooltips.add((Component)text);
        }
    }
}

