/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.raijin_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class HeadRaijinArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart flyA;
    private final ModelPart flyB;
    private final ModelPart flyC;
    private final ModelPart flyD;
    private final ModelPart flyE;
    private final ModelPart flyF;

    public HeadRaijinArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.flyA = this.head.getChild("flyA");
        this.flyB = this.head.getChild("flyB");
        this.flyC = this.head.getChild("flyC");
        this.flyD = this.head.getChild("flyD");
        this.flyE = this.head.getChild("flyE");
        this.flyF = this.head.getChild("flyF");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new HeadRaijinArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = HeadRaijinArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headHornLeftA = head.addOrReplaceChild("headHornLeftA", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)2.5f, (float)-6.5f, (float)-5.0f, (float)-0.2618f, (float)0.0f, (float)0.1745f));
        headHornLeftA.addOrReplaceChild("headHornLeftB", CubeListBuilder.create().texOffs(15, 0).addBox(-0.5f, -5.0f, -3.0f, 1.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.2217f, (float)0.0f, (float)0.0f));
        headHornLeftA.addOrReplaceChild("headHornLeftC", CubeListBuilder.create().texOffs(30, 0).addBox(-0.5f, -3.0f, 2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        headHornLeftA.addOrReplaceChild("headHornLeftD", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -8.0f, 0.8f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition headHornRightA = head.addOrReplaceChild("headHornRightA", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)-2.5f, (float)-6.5f, (float)-5.0f, (float)-0.2618f, (float)0.0f, (float)-0.1745f));
        headHornRightA.addOrReplaceChild("headHornRightB", CubeListBuilder.create().texOffs(15, 0).addBox(-0.5f, -5.0f, -3.0f, 1.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.2217f, (float)0.0f, (float)0.0f));
        headHornRightA.addOrReplaceChild("headHornRightC", CubeListBuilder.create().texOffs(30, 0).addBox(-0.5f, -3.0f, 2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        headHornRightA.addOrReplaceChild("headHornRightD", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -8.0f, 0.8f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("flyA", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)-5.0f, (float)-15.0f, (float)3.0f));
        head.addOrReplaceChild("flyB", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)5.0f, (float)-15.0f, (float)3.0f));
        head.addOrReplaceChild("flyC", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)-11.0f, (float)-7.5f, (float)3.0f));
        head.addOrReplaceChild("flyD", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)11.0f, (float)-7.5f, (float)3.0f));
        head.addOrReplaceChild("flyE", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)-9.0f, (float)2.0f, (float)3.0f));
        head.addOrReplaceChild("flyF", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)9.0f, (float)2.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = HeadRaijinArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headHornLeftA = head.addOrReplaceChild("headHornLeftA", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)2.5f, (float)-6.5f, (float)-5.0f, (float)-0.2618f, (float)0.0f, (float)0.1745f));
        headHornLeftA.addOrReplaceChild("headHornLeftB", CubeListBuilder.create().texOffs(15, 0).addBox(-0.5f, -5.0f, -3.0f, 1.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.2217f, (float)0.0f, (float)0.0f));
        headHornLeftA.addOrReplaceChild("headHornLeftC", CubeListBuilder.create().texOffs(30, 0).addBox(-0.5f, -3.0f, 2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        headHornLeftA.addOrReplaceChild("headHornLeftD", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -8.0f, 0.8f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition headHornRightA = head.addOrReplaceChild("headHornRightA", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)-2.5f, (float)-6.5f, (float)-5.0f, (float)-0.2618f, (float)0.0f, (float)-0.1745f));
        headHornRightA.addOrReplaceChild("headHornRightB", CubeListBuilder.create().texOffs(15, 0).addBox(-0.5f, -5.0f, -3.0f, 1.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.2217f, (float)0.0f, (float)0.0f));
        headHornRightA.addOrReplaceChild("headHornRightC", CubeListBuilder.create().texOffs(30, 0).addBox(-0.5f, -3.0f, 2.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        headHornRightA.addOrReplaceChild("headHornRightD", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -8.0f, 0.8f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("flyA", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)-15.0f, (float)3.0f));
        head.addOrReplaceChild("flyB", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)-15.0f, (float)3.0f));
        head.addOrReplaceChild("flyC", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-10.0f, (float)-7.5f, (float)3.0f));
        head.addOrReplaceChild("flyD", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)10.0f, (float)-7.5f, (float)3.0f));
        head.addOrReplaceChild("flyE", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)2.0f, (float)3.0f));
        head.addOrReplaceChild("flyF", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)2.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float d = ageInTicks / 60.0f;
        float f = d % ((float)Math.PI * 2);
        this.flyA.y = -15.0f + HeadRaijinArmorModel.sinPI(d + 1.0f);
        this.flyA.zRot = f;
        this.flyB.y = -15.0f + HeadRaijinArmorModel.sinPI(d + 1.333f);
        this.flyB.zRot = f + 0.33f;
        this.flyC.y = -7.5f + HeadRaijinArmorModel.sinPI(d + 1.667f);
        this.flyC.zRot = f + 0.67f;
        this.flyD.y = -7.5f + HeadRaijinArmorModel.sinPI(d + 0.333f);
        this.flyD.zRot = f + 0.17f;
        this.flyE.y = 2.0f + HeadRaijinArmorModel.sinPI(d);
        this.flyE.zRot = f + 0.83f;
        this.flyF.y = 2.0f + HeadRaijinArmorModel.sinPI(d + 0.667f);
        this.flyF.zRot = f + 0.5f;
    }
}

