/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.raijin_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class ChestRaijinArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart chestScarfTop;
    private final ModelPart chestScarfRightA;
    private final ModelPart chestScarfRightB;
    private final ModelPart chestScarfRightC;
    private final ModelPart chestScarfTopRightA;
    private final ModelPart chestScarfTopRightB;
    private final ModelPart chestScarfLeftA;
    private final ModelPart chestScarfLeftB;
    private final ModelPart chestScarfLeftC;
    private final ModelPart chestScarfTopLeftA;
    private final ModelPart chestScarfTopLeftB;

    public ChestRaijinArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.chestScarfTop = this.body.getChild("chestScarfTop");
        this.chestScarfRightA = this.body.getChild("chestScarfRightA");
        this.chestScarfRightB = this.chestScarfRightA.getChild("chestScarfRightB");
        this.chestScarfRightC = this.chestScarfRightB.getChild("chestScarfRightC");
        this.chestScarfTopRightA = this.chestScarfTop.getChild("chestScarfTopRightA");
        this.chestScarfTopRightB = this.chestScarfTopRightA.getChild("chestScarfTopRightB");
        this.chestScarfLeftA = this.body.getChild("chestScarfLeftA");
        this.chestScarfLeftB = this.chestScarfLeftA.getChild("chestScarfLeftB");
        this.chestScarfLeftC = this.chestScarfLeftB.getChild("chestScarfLeftC");
        this.chestScarfTopLeftA = this.chestScarfTop.getChild("chestScarfTopLeftA");
        this.chestScarfTopLeftB = this.chestScarfTopLeftA.getChild("chestScarfTopLeftB");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new ChestRaijinArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = ChestRaijinArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition left_arm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, 7.0f, -2.5f, 5.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        left_arm.addOrReplaceChild("armRingLeftB", CubeListBuilder.create().texOffs(15, 1).addBox(-1.5f, 5.5f, -2.5f, 5.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.ZERO);
        PartDefinition right_arm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(30, 0).addBox(-3.5f, 7.0f, -2.5f, 5.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        right_arm.addOrReplaceChild("armRingRightB", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 5.5f, -2.5f, 5.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.ZERO);
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 7).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chestScarfTop = body.addOrReplaceChild("chestScarfTop", CubeListBuilder.create().texOffs(0, 29).addBox(-5.0f, -0.5f, -1.5f, 10.0f, 1.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)6.5f, (float)-1.134464f, (float)0.0f, (float)0.0f));
        PartDefinition chestScarfTopLeftA = chestScarfTop.addOrReplaceChild("chestScarfTopLeftA", CubeListBuilder.create().texOffs(35, 18).addBox(-6.0f, -0.5f, -1.0f, 6.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.094395f));
        chestScarfTopLeftA.addOrReplaceChild("chestScarfTopLeftB", CubeListBuilder.create().texOffs(40, 21).addBox(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.047198f));
        PartDefinition chestScarfTopRightA = chestScarfTop.addOrReplaceChild("chestScarfTopRightA", CubeListBuilder.create().texOffs(35, 18).addBox(-6.0f, -0.5f, -1.0f, 6.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.047198f));
        chestScarfTopRightA.addOrReplaceChild("chestScarfTopRightB", CubeListBuilder.create().texOffs(40, 21).addBox(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.047198f));
        PartDefinition chestScarfLeftA = body.addOrReplaceChild("chestScarfLeftA", CubeListBuilder.create().texOffs(50, 6).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)5.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)0.349066f, (float)0.174533f));
        PartDefinition chestScarfLeftB = chestScarfLeftA.addOrReplaceChild("chestScarfLeftB", CubeListBuilder.create().texOffs(58, 3).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)1.047198f, (float)-0.174533f, (float)0.0f));
        chestScarfLeftB.addOrReplaceChild("chestScarfLeftC", CubeListBuilder.create().texOffs(54, 5).addBox(-1.0f, 0.0f, -0.5f, 2.0f, 6.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)-0.872665f, (float)-0.872665f, (float)0.0f));
        PartDefinition chestScarfRightA = body.addOrReplaceChild("chestScarfRightA", CubeListBuilder.create().texOffs(50, 6).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-5.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.349066f, (float)-0.174533f));
        PartDefinition chestScarfRightB = chestScarfRightA.addOrReplaceChild("chestScarfRightB", CubeListBuilder.create().texOffs(58, 3).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)1.047198f, (float)0.174533f, (float)0.0f));
        chestScarfRightB.addOrReplaceChild("chestScarfRightC", CubeListBuilder.create().texOffs(54, 5).addBox(-1.0f, 0.0f, -0.5f, 2.0f, 6.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)-0.872665f, (float)0.872665f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = ChestRaijinArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition left_arm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 33).addBox(-1.5f, 7.0f, -2.5f, 4.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
        left_arm.addOrReplaceChild("armRingLeftB", CubeListBuilder.create().texOffs(13, 34).addBox(-1.5f, 5.5f, -2.5f, 4.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.ZERO);
        PartDefinition right_arm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(21, 28).addBox(-2.5f, 7.0f, -2.5f, 4.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        right_arm.addOrReplaceChild("armRingRightB", CubeListBuilder.create().texOffs(0, 33).addBox(-2.5f, 5.5f, -2.5f, 4.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.ZERO);
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 7).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("bodyBreast", CubeListBuilder.create().texOffs(26, 34).addBox(-3.5f, 0.0f, -3.65f, 7.0f, 2.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)0.9f, (float)-2.1f, (float)0.994838f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("bodyBreastNecklace", CubeListBuilder.create().texOffs(39, 23).addBox(-4.0f, 0.2f, -5.2f, 8.0f, 0.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.2f, (float)-2.2f, (float)1.00976f, (float)0.0f, (float)0.0f));
        PartDefinition chestScarfTop = body.addOrReplaceChild("chestScarfTop", CubeListBuilder.create().texOffs(0, 29).addBox(-5.0f, -0.5f, -1.5f, 10.0f, 1.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)6.5f, (float)-1.134464f, (float)0.0f, (float)0.0f));
        PartDefinition chestScarfTopLeftA = chestScarfTop.addOrReplaceChild("chestScarfTopLeftA", CubeListBuilder.create().texOffs(35, 18).addBox(-6.0f, -0.5f, -1.0f, 6.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.094395f));
        chestScarfTopLeftA.addOrReplaceChild("chestScarfTopLeftB", CubeListBuilder.create().texOffs(40, 21).addBox(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.047198f));
        PartDefinition chestScarfTopRightA = chestScarfTop.addOrReplaceChild("chestScarfTopRightA", CubeListBuilder.create().texOffs(35, 18).addBox(-6.0f, -0.5f, -1.0f, 6.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.047198f));
        chestScarfTopRightA.addOrReplaceChild("chestScarfTopRightB", CubeListBuilder.create().texOffs(40, 21).addBox(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.047198f));
        PartDefinition chestScarfLeftA = body.addOrReplaceChild("chestScarfLeftA", CubeListBuilder.create().texOffs(50, 6).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)5.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)0.349066f, (float)0.174533f));
        PartDefinition chestScarfLeftB = chestScarfLeftA.addOrReplaceChild("chestScarfLeftB", CubeListBuilder.create().texOffs(58, 3).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)1.047198f, (float)-0.174533f, (float)0.0f));
        chestScarfLeftB.addOrReplaceChild("chestScarfLeftC", CubeListBuilder.create().texOffs(54, 5).addBox(-1.0f, 0.0f, -0.5f, 2.0f, 6.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)-0.872665f, (float)-0.872665f, (float)0.0f));
        PartDefinition chestScarfRightA = body.addOrReplaceChild("chestScarfRightA", CubeListBuilder.create().texOffs(50, 6).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-5.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.349066f, (float)-0.174533f));
        PartDefinition chestScarfRightB = chestScarfRightA.addOrReplaceChild("chestScarfRightB", CubeListBuilder.create().texOffs(58, 3).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)1.047198f, (float)0.174533f, (float)0.0f));
        chestScarfRightB.addOrReplaceChild("chestScarfRightC", CubeListBuilder.create().texOffs(54, 5).addBox(-1.0f, 0.0f, -0.5f, 2.0f, 6.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)-0.872665f, (float)0.872665f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 0.03f * ChestRaijinArmorModel.sinPI(2.0f * ageInTicks / 60.0f);
        float d = (0.866f - ChestRaijinArmorModel.sinPI(0.333f - f)) * 4.0f;
        this.chestScarfTop.y = -4.5f + -d * 0.75f;
        this.chestScarfTop.z = 6.5f + d * 0.8659f;
        this.chestScarfRightA.y = d * 0.5f;
        this.chestScarfRightB.xRot = 1.047f + f * (float)Math.PI;
        this.chestScarfTopRightA.zRot = -1.047f - f * (float)Math.PI;
        this.chestScarfTopRightB.zRot = -1.047f + 2.0f * f * (float)Math.PI;
        this.chestScarfLeftA.y = d * 0.5f;
        this.chestScarfLeftB.xRot = 1.047f + f * (float)Math.PI;
        this.chestScarfTopLeftA.zRot = -2.094f + f * (float)Math.PI;
        this.chestScarfTopLeftB.zRot = 1.047f - 2.0f * f * (float)Math.PI;
        this.chestScarfRightC.xRot = f = -0.872f + 0.03f * ChestRaijinArmorModel.sinPI((ageInTicks - 15.0f) / 30.0f) * (float)Math.PI;
        this.chestScarfLeftC.xRot = f;
    }
}

