/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.quetzalcoatl_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class LegsQuetzalcoatlArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart underwearFront;
    private final ModelPart underwearBack;

    public LegsQuetzalcoatlArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.underwearFront = this.body.getChild("underwearFront");
        this.underwearBack = this.body.getChild("underwearBack");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new LegsQuetzalcoatlArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = LegsQuetzalcoatlArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(45, 31).addBox(-4.5f, 9.5f, -2.5f, 9.0f, 2.0f, 5.0f, new CubeDeformation(-0.1f)).texOffs(61, 24).addBox(-4.5f, 10.0f, -2.5f, 9.0f, 1.0f, 5.0f, CubeDeformation.NONE).texOffs(26, 36).addBox(-2.0f, 9.0f, -2.46f, 4.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("stomachProtectionTop", CubeListBuilder.create().texOffs(36, 36).addBox(-2.0f, 6.0f, -2.45f, 3.0f, 3.0f, 1.0f, new CubeDeformation(-0.087f)), PartPose.offsetAndRotation((float)5.6586f, (float)4.0503f, (float)-0.087f, (float)0.0f, (float)0.0f, (float)0.7854f));
        body.addOrReplaceChild("stomachProtectionLeft", CubeListBuilder.create().texOffs(98, 28).mirror(true).addBox(-2.35f, -2.0f, -0.04f, 2.0f, 2.0f, 5.0f, new CubeDeformation(-0.05f)), PartPose.offsetAndRotation((float)4.45f, (float)11.0f, (float)-2.46f, (float)0.0f, (float)0.0f, (float)0.3927f));
        body.addOrReplaceChild("stomachProtectionRight", CubeListBuilder.create().texOffs(98, 28).addBox(0.35f, -2.0f, -0.04f, 2.0f, 2.0f, 5.0f, new CubeDeformation(-0.05f)), PartPose.offsetAndRotation((float)-4.45f, (float)11.0f, (float)-2.46f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        body.addOrReplaceChild("stomachJewel", CubeListBuilder.create().texOffs(30, 27).addBox(-1.0f, -1.0f, -0.75f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)11.0f, (float)-2.25f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition underwearFront = body.addOrReplaceChild("underwearFront", CubeListBuilder.create().texOffs(78, 30).addBox(-2.5f, 0.15f, -0.15f, 5.0f, 7.0f, 0.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)11.25f, (float)-2.25f));
        underwearFront.addOrReplaceChild("underwearFeather", CubeListBuilder.create().texOffs(40, 13).addBox(5.25f, -11.25f, -2.6f, 6.0f, 6.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)12.75f, (float)2.25f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        body.addOrReplaceChild("underwearBack", CubeListBuilder.create().texOffs(68, 30).addBox(-2.5f, 0.1f, 0.1f, 5.0f, 5.0f, 0.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)11.3f, (float)2.3f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = Math.abs(0.05f + 1.02f * this.rightLeg.xRot) + 0.05f * (1.0f + LegsQuetzalcoatlArmorModel.sinPI(ageInTicks / 40.0f));
        this.underwearFront.xRot = -f;
        this.underwearBack.xRot = f;
    }
}

